/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.AbstractResponse;
import io.atomix.copycat.protocol.Response;
import java.util.Objects;

public class ConfigureResponse
extends AbstractResponse {
    public static Builder builder() {
        return new Builder(new ConfigureResponse());
    }

    public static Builder builder(ConfigureResponse response) {
        return new Builder(response);
    }

    public void readObject(BufferInput buffer, Serializer serializer) {
        this.status = Response.Status.forId(buffer.readByte());
        this.error = this.status == Response.Status.OK ? null : CopycatError.forId(buffer.readByte());
    }

    public void writeObject(BufferOutput buffer, Serializer serializer) {
        buffer.writeByte(this.status.id());
        if (this.status == Response.Status.ERROR) {
            buffer.writeByte(this.error.id());
        }
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status});
    }

    public boolean equals(Object object) {
        if (object instanceof ConfigureResponse) {
            ConfigureResponse response = (ConfigureResponse)object;
            return response.status == this.status;
        }
        return false;
    }

    @Override
    public String toString() {
        return String.format("%s[status=%s]", new Object[]{this.getClass().getSimpleName(), this.status});
    }

    public static class Builder
    extends AbstractResponse.Builder<Builder, ConfigureResponse> {
        protected Builder(ConfigureResponse response) {
            super(response);
        }
    }
}

