/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.AbstractRequest;
import java.util.Objects;
import java.util.UUID;

public class AcceptRequest
extends AbstractRequest {
    private UUID client;
    private Address address;

    public static Builder builder() {
        return new Builder(new AcceptRequest());
    }

    public static Builder builder(AcceptRequest request) {
        return new Builder(request);
    }

    public UUID client() {
        return this.client;
    }

    public Address address() {
        return this.address;
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.client = UUID.fromString(buffer.readString());
        this.address = (Address)serializer.readObject(buffer);
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeString(this.client.toString());
        serializer.writeObject(this.address, buffer);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.client, this.address);
    }

    public boolean equals(Object object) {
        if (object instanceof AcceptRequest) {
            AcceptRequest request = (AcceptRequest)object;
            return request.client.equals(this.client) && request.address.equals(this.address);
        }
        return false;
    }

    public String toString() {
        return String.format("%s[client=%s, address=%s]", this.getClass().getSimpleName(), this.client, this.address);
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, AcceptRequest> {
        protected Builder(AcceptRequest request) {
            super(request);
        }

        public Builder withClient(UUID client) {
            ((AcceptRequest)this.request).client = Assert.notNull(client, "client");
            return this;
        }

        public Builder withAddress(Address address) {
            ((AcceptRequest)this.request).address = Assert.notNull(address, "address");
            return this;
        }

        @Override
        public AcceptRequest build() {
            super.build();
            Assert.stateNot(((AcceptRequest)this.request).client == null, "client cannot be null", new Object[0]);
            Assert.stateNot(((AcceptRequest)this.request).address == null, "address cannot be null", new Object[0]);
            return (AcceptRequest)this.request;
        }
    }
}

