/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.AbstractRequest;

public abstract class SessionRequest
extends AbstractRequest {
    protected long session;

    public long session() {
        return this.session;
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.session = buffer.readLong();
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeLong(this.session);
    }

    public static abstract class Builder<T extends Builder<T, U>, U extends SessionRequest>
    extends AbstractRequest.Builder<T, U> {
        protected Builder(U request) {
            super(request);
        }

        public T withSession(long session) {
            ((SessionRequest)this.request).session = Assert.argNot(session, session < 1L, "session cannot be less than 1", new Object[0]);
            return (T)this;
        }

        @Override
        public U build() {
            super.build();
            Assert.stateNot(((SessionRequest)this.request).session < 1L, "session cannot be less than 1", new Object[0]);
            return (U)((SessionRequest)this.request);
        }
    }
}

