/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client.util;

import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.MessageHandler;
import io.atomix.catalyst.transport.TransportException;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.Listener;
import io.atomix.copycat.client.util.AddressSelector;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.protocol.ConnectRequest;
import io.atomix.copycat.protocol.ConnectResponse;
import io.atomix.copycat.protocol.Request;
import io.atomix.copycat.protocol.Response;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnection
implements Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientConnection.class);
    private final UUID id;
    private final Client client;
    private final AddressSelector selector;
    private CompletableFuture<Connection> connectFuture;
    private final Map<Class<?>, MessageHandler<?, ?>> handlers = new ConcurrentHashMap();
    private Connection connection;
    private boolean open = true;

    public ClientConnection(UUID id, Client client, AddressSelector selector) {
        this.id = Assert.notNull(id, "id");
        this.client = Assert.notNull(client, "client");
        this.selector = Assert.notNull(selector, "selector");
    }

    public Address leader() {
        return this.selector.leader();
    }

    public Collection<Address> servers() {
        return this.selector.servers();
    }

    public ClientConnection reset() {
        this.selector.reset();
        return this;
    }

    public ClientConnection reset(Address leader, Collection<Address> servers) {
        this.selector.reset(leader, servers);
        return this;
    }

    @Override
    public <T, U> CompletableFuture<U> send(T request) {
        CompletableFuture future = new CompletableFuture();
        this.sendRequest((Request)request, future);
        return future;
    }

    private <T extends Request, U extends Response> void sendRequest(T request, CompletableFuture<U> future) {
        if (this.open) {
            this.connect().whenComplete((c, e) -> this.sendRequest(request, (Connection)c, (Throwable)e, future));
        }
    }

    private <T extends Request, U extends Response> void sendRequest(T request, Connection connection, Throwable error, CompletableFuture<U> future) {
        if (this.open) {
            if (error == null) {
                if (connection != null) {
                    connection.send(request).whenComplete((r, e) -> this.handleResponse(request, (Response)r, (Throwable)e, future));
                } else {
                    future.completeExceptionally(new ConnectException("failed to connect"));
                }
            } else {
                this.connection = null;
                this.next().whenComplete((c, e) -> this.sendRequest(request, (Connection)c, (Throwable)e, future));
            }
        }
    }

    private <T extends Request, U extends Response> void handleResponse(T request, U response, Throwable error, CompletableFuture<U> future) {
        if (this.open) {
            if (error == null) {
                if (response.status() == Response.Status.OK || response.error() == CopycatError.Type.COMMAND_ERROR || response.error() == CopycatError.Type.QUERY_ERROR || response.error() == CopycatError.Type.APPLICATION_ERROR || response.error() == CopycatError.Type.UNKNOWN_SESSION_ERROR) {
                    future.complete(response);
                } else {
                    this.next().whenComplete((c, e) -> this.sendRequest(request, (Connection)c, (Throwable)e, future));
                }
            } else if (error instanceof ConnectException || error instanceof TimeoutException || error instanceof TransportException || error instanceof ClosedChannelException) {
                this.next().whenComplete((c, e) -> this.sendRequest(request, (Connection)c, (Throwable)e, future));
            } else {
                future.completeExceptionally(error);
            }
        }
    }

    private CompletableFuture<Connection> connect() {
        if (this.selector.state() == AddressSelector.State.RESET && this.connection != null) {
            if (this.connectFuture != null) {
                return this.connectFuture;
            }
            CompletableFuture future = new CompletableFuture();
            this.connectFuture = future;
            this.connection.close().whenComplete((result, error) -> this.connect(future));
            return this.connectFuture.whenComplete((result, error) -> {
                this.connectFuture = null;
            });
        }
        if (this.connection != null) {
            return CompletableFuture.completedFuture(this.connection);
        }
        if (this.connectFuture != null) {
            return this.connectFuture;
        }
        this.connectFuture = new CompletableFuture();
        this.connect(this.connectFuture);
        return this.connectFuture.whenComplete((result, error) -> {
            this.connectFuture = null;
        });
    }

    private CompletableFuture<Connection> next() {
        if (this.connection != null) {
            return ((CompletableFuture)this.connection.close().thenRun(() -> {
                this.connection = null;
            })).thenCompose(v -> this.connect());
        }
        return this.connect();
    }

    private void connect(CompletableFuture<Connection> future) {
        if (!this.selector.hasNext()) {
            LOGGER.debug("Failed to connect to the cluster");
            future.complete(null);
        } else {
            Address address = this.selector.next();
            LOGGER.debug("Connecting to {}", (Object)address);
            this.client.connect(address).whenComplete((c, e) -> this.handleConnection(address, (Connection)c, (Throwable)e, future));
        }
    }

    private void handleConnection(Address address, Connection connection, Throwable error, CompletableFuture<Connection> future) {
        if (this.open) {
            if (error == null) {
                this.setupConnection(address, connection, future);
            } else {
                this.connect(future);
            }
        }
    }

    private void setupConnection(Address address, Connection connection, CompletableFuture<Connection> future) {
        LOGGER.debug("Setting up connection to {}", (Object)address);
        this.connection = connection;
        connection.closeListener(c -> {
            if (c.equals(this.connection)) {
                LOGGER.debug("Connection closed");
                this.connection = null;
            }
        });
        connection.exceptionListener(c -> {
            if (c.equals(this.connection)) {
                LOGGER.debug("Connection lost");
                this.connection = null;
            }
        });
        for (Map.Entry<Class<?>, MessageHandler<?, ?>> entry : this.handlers.entrySet()) {
            connection.handler(entry.getKey(), entry.getValue());
        }
        ConnectRequest request = ConnectRequest.builder().withClientId(this.id).build();
        LOGGER.debug("Sending {}", (Object)request);
        connection.send(request).whenComplete((r, e) -> this.handleConnectResponse((ConnectResponse)r, (Throwable)e, future));
    }

    private void handleConnectResponse(ConnectResponse response, Throwable error, CompletableFuture<Connection> future) {
        if (this.open) {
            if (error == null) {
                LOGGER.debug("Received {}", (Object)response);
                if (response.status() == Response.Status.OK) {
                    this.selector.reset(response.leader(), response.members());
                    future.complete(this.connection);
                } else {
                    this.connect(future);
                }
            } else {
                this.connect(future);
            }
        }
    }

    @Override
    public <T, U> Connection handler(Class<T> type, MessageHandler<T, U> handler) {
        Assert.notNull(type, "type");
        Assert.notNull(handler, "handler");
        this.handlers.put(type, handler);
        if (this.connection != null) {
            this.connection.handler(type, handler);
        }
        return this;
    }

    @Override
    public Listener<Throwable> exceptionListener(Consumer<Throwable> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Listener<Connection> closeListener(Consumer<Connection> listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CompletableFuture<Void> close() {
        this.open = false;
        return CompletableFuture.completedFuture(null);
    }
}

