/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client.session;

import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.TransportException;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.copycat.Command;
import io.atomix.copycat.NoOpCommand;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.session.ClientSequencer;
import io.atomix.copycat.client.session.ClientSessionState;
import io.atomix.copycat.error.CommandException;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.error.QueryException;
import io.atomix.copycat.protocol.CommandRequest;
import io.atomix.copycat.protocol.CommandResponse;
import io.atomix.copycat.protocol.OperationRequest;
import io.atomix.copycat.protocol.OperationResponse;
import io.atomix.copycat.protocol.QueryRequest;
import io.atomix.copycat.protocol.QueryResponse;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.session.ClosedSessionException;
import io.atomix.copycat.session.Session;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

final class ClientSessionSubmitter {
    private static final int[] FIBONACCI = new int[]{1, 1, 2, 3, 5};
    private static final Predicate<Throwable> EXCEPTION_PREDICATE = e -> e instanceof ConnectException || e instanceof TimeoutException || e instanceof TransportException || e instanceof ClosedChannelException;
    private final Connection connection;
    private final ClientSessionState state;
    private final ClientSequencer sequencer;
    private final ThreadContext context;
    private final Map<Long, OperationAttempt> attempts = new HashMap<Long, OperationAttempt>();

    public ClientSessionSubmitter(Connection connection, ClientSessionState state, ClientSequencer sequencer, ThreadContext context) {
        this.connection = Assert.notNull(connection, "connection");
        this.state = Assert.notNull(state, "state");
        this.sequencer = Assert.notNull(sequencer, "sequencer");
        this.context = Assert.notNull(context, "context");
    }

    public <T> CompletableFuture<T> submit(Command<T> command) {
        CompletableFuture future = new CompletableFuture();
        this.context.executor().execute(() -> this.submitCommand(command, future));
        return future;
    }

    private <T> void submitCommand(Command<T> command, CompletableFuture<T> future) {
        CommandRequest request = ((CommandRequest.Builder)((CommandRequest.Builder)CommandRequest.builder().withSession(this.state.getSessionId())).withSequence(this.state.nextCommandRequest())).withCommand(command).build();
        this.submitCommand(request, future);
    }

    private <T> void submitCommand(CommandRequest request, CompletableFuture<T> future) {
        this.submit(new CommandAttempt<T>(this.sequencer.nextRequest(), request, future));
    }

    public <T> CompletableFuture<T> submit(Query<T> query) {
        CompletableFuture future = new CompletableFuture();
        this.context.executor().execute(() -> this.submitQuery(query, future));
        return future;
    }

    private <T> void submitQuery(Query<T> query, CompletableFuture<T> future) {
        QueryRequest request = ((QueryRequest.Builder)((QueryRequest.Builder)QueryRequest.builder().withSession(this.state.getSessionId())).withSequence(this.state.getCommandRequest())).withIndex(this.state.getResponseIndex()).withQuery(query).build();
        this.submitQuery(request, future);
    }

    private <T> void submitQuery(QueryRequest request, CompletableFuture<T> future) {
        this.submit(new QueryAttempt<T>(this.sequencer.nextRequest(), request, future));
    }

    private <T extends OperationRequest, U extends OperationResponse, V> void submit(OperationAttempt<T, U, V> attempt) {
        if (this.state.getState() == Session.State.CLOSED || this.state.getState() == Session.State.EXPIRED) {
            attempt.fail(new ClosedSessionException("session closed"));
        } else {
            this.state.getLogger().debug("{} - Sending {}", (Object)this.state.getSessionId(), attempt.request);
            this.attempts.put(attempt.sequence, attempt);
            this.connection.send(attempt.request).whenComplete(attempt);
        }
    }

    public CompletableFuture<Void> close() {
        for (OperationAttempt attempt : this.attempts.values()) {
            attempt.fail(new ClosedSessionException("session closed"));
        }
        return CompletableFuture.completedFuture(null);
    }

    private final class QueryAttempt<T>
    extends OperationAttempt<QueryRequest, QueryResponse, T> {
        public QueryAttempt(long sequence, QueryRequest request, CompletableFuture<T> future) {
            super(ClientSessionSubmitter.this, sequence, 1, (OperationRequest)request, future);
        }

        public QueryAttempt(long sequence, int attempt, QueryRequest request, CompletableFuture<T> future) {
            super(ClientSessionSubmitter.this, sequence, attempt, (OperationRequest)request, future);
        }

        @Override
        protected OperationAttempt<QueryRequest, QueryResponse, T> next() {
            return new QueryAttempt<T>(this.sequence, this.attempt + 1, (QueryRequest)this.request, this.future);
        }

        @Override
        protected Throwable defaultException() {
            return new QueryException("failed to complete query", new Object[0]);
        }

        @Override
        public void accept(QueryResponse response, Throwable error) {
            if (error == null) {
                ClientSessionSubmitter.this.state.getLogger().debug("{} - Received {}", (Object)ClientSessionSubmitter.this.state.getSessionId(), (Object)response);
                if (response.status() == Response.Status.OK) {
                    this.complete(response);
                } else {
                    this.complete(response.error().createException());
                }
            } else {
                this.fail(error);
            }
        }

        @Override
        protected void complete(QueryResponse response) {
            this.sequence(response, () -> {
                ClientSessionSubmitter.this.state.setResponseIndex(response.index());
                this.future.complete(response.result());
            });
        }

        @Override
        protected void complete(Throwable error) {
            this.future.completeExceptionally(error);
        }
    }

    private final class CommandAttempt<T>
    extends OperationAttempt<CommandRequest, CommandResponse, T> {
        public CommandAttempt(long sequence, CommandRequest request, CompletableFuture<T> future) {
            super(ClientSessionSubmitter.this, sequence, 1, (OperationRequest)request, future);
        }

        public CommandAttempt(long sequence, int attempt, CommandRequest request, CompletableFuture<T> future) {
            super(ClientSessionSubmitter.this, sequence, attempt, (OperationRequest)request, future);
        }

        @Override
        protected OperationAttempt<CommandRequest, CommandResponse, T> next() {
            return new CommandAttempt<T>(this.sequence, this.attempt + 1, (CommandRequest)this.request, this.future);
        }

        @Override
        protected Throwable defaultException() {
            return new CommandException("failed to complete command", new Object[0]);
        }

        @Override
        public void accept(CommandResponse response, Throwable error) {
            if (error == null) {
                ClientSessionSubmitter.this.state.getLogger().debug("{} - Received {}", (Object)ClientSessionSubmitter.this.state.getSessionId(), (Object)response);
                if (response.status() == Response.Status.OK) {
                    this.complete(response);
                } else if (response.error() == CopycatError.Type.APPLICATION_ERROR) {
                    this.complete(response.error().createException());
                } else if (response.error() != CopycatError.Type.UNKNOWN_SESSION_ERROR) {
                    this.retry(Duration.ofSeconds(FIBONACCI[Math.min(this.attempt - 1, FIBONACCI.length - 1)]));
                }
            } else if (EXCEPTION_PREDICATE.test(error) || error instanceof CompletionException && EXCEPTION_PREDICATE.test(error.getCause())) {
                this.retry(Duration.ofSeconds(FIBONACCI[Math.min(this.attempt - 1, FIBONACCI.length - 1)]));
            } else {
                this.fail(error);
            }
        }

        @Override
        public void fail(Throwable t) {
            super.fail(t);
            CommandRequest request = ((CommandRequest.Builder)((CommandRequest.Builder)CommandRequest.builder().withSession(((CommandRequest)this.request).session())).withSequence(((CommandRequest)this.request).sequence())).withCommand(new NoOpCommand()).build();
            ClientSessionSubmitter.this.context.executor().execute(() -> ClientSessionSubmitter.this.submit(new CommandAttempt<T>(this.sequence, this.attempt + 1, request, this.future)));
        }

        @Override
        protected void complete(CommandResponse response) {
            this.sequence(response, () -> {
                ClientSessionSubmitter.this.state.setCommandResponse(((CommandRequest)this.request).sequence());
                ClientSessionSubmitter.this.state.setResponseIndex(response.index());
                this.future.complete(response.result());
            });
        }

        @Override
        protected void complete(Throwable error) {
            this.sequence(null, () -> this.future.completeExceptionally(error));
        }
    }

    private abstract class OperationAttempt<T extends OperationRequest, U extends OperationResponse, V>
    implements BiConsumer<U, Throwable> {
        protected final long sequence;
        protected final int attempt;
        protected final T request;
        protected final CompletableFuture<V> future;
        final /* synthetic */ ClientSessionSubmitter this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        protected OperationAttempt(long attempt, int future, T t, CompletableFuture<V> completableFuture) {
            void request;
            void sequence;
            this.this$0 = (ClientSessionSubmitter)l;
            this.sequence = sequence;
            this.attempt = (int)attempt;
            this.request = request;
            this.future = (CompletableFuture<V>)future;
        }

        protected abstract OperationAttempt<T, U, V> next();

        protected abstract Throwable defaultException();

        protected abstract void complete(U var1);

        protected abstract void complete(Throwable var1);

        protected final void sequence(OperationResponse response, Runnable callback) {
            this.this$0.sequencer.sequenceResponse(this.sequence, response, callback);
        }

        public void fail() {
            this.fail(this.defaultException());
        }

        public void fail(Throwable t) {
            this.complete(t);
        }

        public void retry() {
            this.this$0.context.executor().execute(() -> this.this$0.submit(this.next()));
        }

        public void retry(Duration after) {
            this.this$0.context.schedule(after, () -> this.this$0.submit(this.next()));
        }
    }
}

