/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client;

import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.ConfigurationException;
import io.atomix.catalyst.util.Listener;
import io.atomix.catalyst.util.concurrent.SingleThreadContext;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.copycat.Command;
import io.atomix.copycat.Operation;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.ConnectionStrategies;
import io.atomix.copycat.client.ConnectionStrategy;
import io.atomix.copycat.client.DefaultCopycatClient;
import io.atomix.copycat.client.RecoveryStrategies;
import io.atomix.copycat.client.RecoveryStrategy;
import io.atomix.copycat.client.ServerSelectionStrategies;
import io.atomix.copycat.client.ServerSelectionStrategy;
import io.atomix.copycat.protocol.ClientRequestTypeResolver;
import io.atomix.copycat.protocol.ClientResponseTypeResolver;
import io.atomix.copycat.session.Session;
import io.atomix.copycat.util.ProtocolSerialization;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public interface CopycatClient {
    public static Builder builder() {
        return CopycatClient.builder(Collections.EMPTY_LIST);
    }

    public static Builder builder(Address ... cluster) {
        return CopycatClient.builder(Arrays.asList(cluster));
    }

    public static Builder builder(Collection<Address> cluster) {
        return new Builder(cluster);
    }

    public State state();

    public Listener<State> onStateChange(Consumer<State> var1);

    public ThreadContext context();

    public Transport transport();

    public Serializer serializer();

    public Session session();

    default public <T> CompletableFuture<T> submit(Operation<T> operation) {
        Assert.notNull(operation, "operation");
        if (operation instanceof Command) {
            return this.submit((Command)operation);
        }
        if (operation instanceof Query) {
            return this.submit((Query)operation);
        }
        throw new IllegalArgumentException("unknown operation type");
    }

    public <T> CompletableFuture<T> submit(Command<T> var1);

    public <T> CompletableFuture<T> submit(Query<T> var1);

    public Listener<Void> onEvent(String var1, Runnable var2);

    public <T> Listener<T> onEvent(String var1, Consumer<T> var2);

    default public CompletableFuture<CopycatClient> connect() {
        return this.connect((Collection<Address>)null);
    }

    default public CompletableFuture<CopycatClient> connect(Address ... members) {
        if (members == null || members.length == 0) {
            return this.connect();
        }
        return this.connect(Arrays.asList(members));
    }

    public CompletableFuture<CopycatClient> connect(Collection<Address> var1);

    public CompletableFuture<CopycatClient> recover();

    public CompletableFuture<Void> close();

    public static final class Builder
    implements io.atomix.catalyst.util.Builder<CopycatClient> {
        private final Collection<Address> cluster;
        private Transport transport;
        private Serializer serializer;
        private ConnectionStrategy connectionStrategy = ConnectionStrategies.ONCE;
        private ServerSelectionStrategy serverSelectionStrategy = ServerSelectionStrategies.ANY;
        private RecoveryStrategy recoveryStrategy = RecoveryStrategies.CLOSE;

        private Builder(Collection<Address> cluster) {
            this.cluster = Assert.notNull(cluster, "cluster");
        }

        public Builder withTransport(Transport transport) {
            this.transport = Assert.notNull(transport, "transport");
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.serializer = Assert.notNull(serializer, "serializer");
            return this;
        }

        public Builder withConnectionStrategy(ConnectionStrategy connectionStrategy) {
            this.connectionStrategy = Assert.notNull(connectionStrategy, "connectionStrategy");
            return this;
        }

        public Builder withServerSelectionStrategy(ServerSelectionStrategy serverSelectionStrategy) {
            this.serverSelectionStrategy = Assert.notNull(serverSelectionStrategy, "serverSelectionStrategy");
            return this;
        }

        public Builder withRecoveryStrategy(RecoveryStrategy recoveryStrategy) {
            this.recoveryStrategy = Assert.notNull(recoveryStrategy, "recoveryStrategy");
            return this;
        }

        @Override
        public CopycatClient build() {
            if (this.transport == null) {
                try {
                    this.transport = (Transport)Class.forName("io.atomix.catalyst.transport.NettyTransport").newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new ConfigurationException("transport not configured", new Object[0]);
                }
            }
            if (this.serializer == null) {
                this.serializer = new Serializer();
            }
            this.serializer.resolve(new ClientRequestTypeResolver());
            this.serializer.resolve(new ClientResponseTypeResolver());
            this.serializer.resolve(new ProtocolSerialization());
            return new DefaultCopycatClient(this.cluster, this.transport, new SingleThreadContext("copycat-client-io-%d", this.serializer.clone()), new SingleThreadContext("copycat-client-event-%d", this.serializer.clone()), this.serverSelectionStrategy, this.connectionStrategy, this.recoveryStrategy);
        }
    }

    public static enum State {
        CONNECTED,
        SUSPENDED,
        CLOSED;

    }
}

