/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport;

import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.NettyClient;
import io.atomix.catalyst.transport.NettyOptions;
import io.atomix.catalyst.transport.NettyServer;
import io.atomix.catalyst.transport.Server;
import io.atomix.catalyst.transport.SslProtocol;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.concurrent.CatalystThreadFactory;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.Properties;

public class NettyTransport
implements Transport {
    private final NettyOptions properties;
    private final EventLoopGroup eventLoopGroup;

    public static Builder builder() {
        return new Builder();
    }

    public NettyTransport() {
        this(new NettyOptions(new Properties()));
    }

    public NettyTransport(Properties properties) {
        this(new NettyOptions(properties));
    }

    public NettyTransport(NettyOptions properties) {
        this.properties = Assert.notNull(properties, "properties");
        CatalystThreadFactory threadFactory = new CatalystThreadFactory("catalyst-event-loop-%d");
        this.eventLoopGroup = new NioEventLoopGroup(properties.threads(), threadFactory);
    }

    public NettyOptions properties() {
        return this.properties;
    }

    public EventLoopGroup eventLoopGroup() {
        return this.eventLoopGroup;
    }

    @Override
    public Client client() {
        return new NettyClient(this);
    }

    @Override
    public Server server() {
        return new NettyServer(this);
    }

    @Override
    public void close() {
        try {
            this.eventLoopGroup.shutdownGracefully().sync();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static class Builder
    implements Transport.Builder {
        private final Properties properties = new Properties();

        private Builder() {
        }

        public Builder withThreads(int threads) {
            this.properties.setProperty("threads", String.valueOf(Assert.argNot(threads, threads <= 0, "threads must be positive", new Object[0])));
            return this;
        }

        public Builder withConnectTimeout(int timeout) {
            this.properties.setProperty("connectTimeout", String.valueOf(Assert.argNot(timeout, timeout <= 0, "timeout must be positive", new Object[0])));
            return this;
        }

        public Builder withSendBufferSize(int sendBufferSize) {
            this.properties.setProperty("sendBufferSize", String.valueOf(Assert.argNot(sendBufferSize, sendBufferSize <= 0, "buffer size must be positive", new Object[0])));
            return this;
        }

        public Builder withReceiveBufferSize(int receiveBufferSize) {
            this.properties.setProperty("receiveBufferSize", String.valueOf(Assert.argNot(receiveBufferSize, receiveBufferSize <= 0, "buffer size must be positive", new Object[0])));
            return this;
        }

        public Builder withReuseAddress() {
            return this.withReuseAddress(true);
        }

        public Builder withReuseAddress(boolean reuseAddress) {
            this.properties.setProperty("reuseAddress", String.valueOf(reuseAddress));
            return this;
        }

        public Builder withTcpKeepAlive() {
            return this.withTcpKeepAlive(true);
        }

        public Builder withTcpKeepAlive(boolean tcpKeepAlive) {
            this.properties.setProperty("tcpKeepAlive", String.valueOf(tcpKeepAlive));
            return this;
        }

        public Builder withTcpNoDelay() {
            return this.withTcpNoDelay(true);
        }

        public Builder withTcpNoDelay(boolean tcpNoDelay) {
            this.properties.setProperty("tcpNoDelay", String.valueOf(tcpNoDelay));
            return this;
        }

        public Builder withAcceptBacklog(int acceptBacklog) {
            this.properties.setProperty("acceptBacklog", String.valueOf(Assert.argNot(acceptBacklog, acceptBacklog <= 0, "accept backlog must be positive", new Object[0])));
            return this;
        }

        public Builder withSsl() {
            return this.withSsl(true);
        }

        public Builder withSsl(boolean sslEnabled) {
            this.properties.setProperty("ssl.enabled", String.valueOf(sslEnabled));
            return this;
        }

        public Builder withSslProtocol(SslProtocol sslProtocol) {
            this.properties.setProperty("ssl.protocol", Assert.notNull(sslProtocol, "sslProtocol").name().replace("_", "."));
            return this;
        }

        public Builder withTrustStorePath(String trustStorePath) {
            this.properties.setProperty("ssl.trustStore.path", Assert.notNull(trustStorePath, "trustStorePath"));
            return this;
        }

        public Builder withTrustStorePassword(String trustStorePassword) {
            this.properties.setProperty("ssl.trustStore.password", Assert.notNull(trustStorePassword, "trustStorePassword"));
            return this;
        }

        public Builder withKeyStorePath(String keyStorePath) {
            this.properties.setProperty("ssl.keyStore.path", Assert.notNull(keyStorePath, "keyStorePath"));
            return this;
        }

        public Builder withKeyStorePassword(String trustStorePassword) {
            this.properties.setProperty("ssl.keyStore.password", Assert.notNull(trustStorePassword, "trustStorePassword"));
            return this;
        }

        public Builder withKeyStoreKeyPassword(String keyStoreKeyPassword) {
            this.properties.setProperty("ssl.keyStore.keyPassword", Assert.notNull(keyStoreKeyPassword, "trustStorePassword"));
            return this;
        }

        @Override
        public Transport build() {
            return new NettyTransport(this.properties);
        }
    }
}

