/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport;

import io.atomix.catalyst.transport.NettyOptions;
import io.atomix.catalyst.util.Assert;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NettyTls {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyTls.class);
    private NettyOptions properties;

    public NettyTls(NettyOptions properties) {
        this.properties = properties;
    }

    public SSLEngine initSslEngine(boolean client) throws Exception {
        KeyStore trustStore;
        KeyStore keyStore = this.loadKeystore(this.properties.sslKeyStorePath(), this.properties.sslKeyStorePassword());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, this.keyStoreKeyPass(this.properties));
        if (this.properties.sslTrustStorePath() != null) {
            LOGGER.debug("Using separate trust store");
            trustStore = this.loadKeystore(this.properties.sslTrustStorePath(), this.properties.sslTrustStorePassword());
        } else {
            trustStore = keyStore;
            LOGGER.debug("Using key store as trust store");
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(trustStore);
        KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
        TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(keyManagers, trustManagers, null);
        SSLEngine sslEngine = sslContext.createSSLEngine();
        sslEngine.setUseClientMode(client);
        sslEngine.setWantClientAuth(true);
        sslEngine.setEnabledProtocols(sslEngine.getSupportedProtocols());
        sslEngine.setEnabledCipherSuites(sslEngine.getSupportedCipherSuites());
        sslEngine.setEnableSessionCreation(true);
        return sslEngine;
    }

    private KeyStore loadKeystore(String path, String password) throws Exception {
        Assert.notNull(path, "Path");
        File file = new File(path);
        LOGGER.debug("Using JKS at {}", (Object)file.getCanonicalPath());
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(new FileInputStream(file.getCanonicalPath()), password.toCharArray());
        return ks;
    }

    private char[] keyStoreKeyPass(NettyOptions properties) throws Exception {
        if (properties.sslKeyStoreKeyPassword() != null) {
            return properties.sslKeyStoreKeyPassword().toCharArray();
        }
        return properties.sslKeyStorePassword().toCharArray();
    }
}

