/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport;

import io.atomix.catalyst.transport.SslProtocol;
import io.atomix.catalyst.util.ConfigurationException;
import io.atomix.catalyst.util.PropertiesReader;
import java.util.Properties;

public final class NettyOptions {
    public static final String THREADS = "threads";
    public static final String CONNECT_TIMEOUT = "connectTimeout";
    public static final String SEND_BUFFER_SIZE = "sendBufferSize";
    public static final String RECEIVE_BUFFER_SIZE = "receiveBufferSize";
    public static final String REUSE_ADDRESS = "reuseAddress";
    public static final String TCP_KEEP_ALIVE = "tcpKeepAlive";
    public static final String TCP_NO_DELAY = "tcpNoDelay";
    public static final String ACCEPT_BACKLOG = "acceptBacklog";
    public static final String SSL_ENABLED = "ssl.enabled";
    public static final String SSL_PROTOCOL = "ssl.protocol";
    public static final String SSL_TRUST_STORE_PATH = "ssl.trustStore.path";
    public static final String SSL_TRUST_STORE_PASSWORD = "ssl.trustStore.password";
    public static final String SSL_KEY_STORE_PATH = "ssl.keyStore.path";
    public static final String SSL_KEY_STORE_PASSWORD = "ssl.keyStore.password";
    public static final String SSL_KEY_STORE_KEY_PASSWORD = "ssl.keyStore.keyPassword";
    private static final int DEFAULT_THREADS = Runtime.getRuntime().availableProcessors();
    private static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    private static final int DEFAULT_SEND_BUFFER_SIZE = -1;
    private static final int DEFAULT_RECEIVE_BUFFER_SIZE = -1;
    private static final boolean DEFAULT_REUSE_ADDRESS = true;
    private static final boolean DEFAULT_TCP_KEEP_ALIVE = true;
    private static final boolean DEFAULT_TCP_NO_DELAY = false;
    private static final int DEFAULT_ACCEPT_BACKLOG = 1024;
    private static final boolean DEFAULT_SSL_ENABLED = false;
    private static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";
    private final PropertiesReader reader;

    public NettyOptions(Properties properties) {
        this.reader = new PropertiesReader(properties);
    }

    public int threads() {
        int threads = this.reader.getInteger(THREADS, DEFAULT_THREADS);
        if (threads == -1) {
            return Runtime.getRuntime().availableProcessors();
        }
        return threads;
    }

    public int connectTimeout() {
        return this.reader.getInteger(CONNECT_TIMEOUT, 5000);
    }

    public int sendBufferSize() {
        return this.reader.getInteger(SEND_BUFFER_SIZE, -1);
    }

    public int receiveBufferSize() {
        return this.reader.getInteger(RECEIVE_BUFFER_SIZE, -1);
    }

    public boolean reuseAddress() {
        return this.reader.getBoolean(REUSE_ADDRESS, true);
    }

    public boolean tcpKeepAlive() {
        return this.reader.getBoolean(TCP_KEEP_ALIVE, true);
    }

    public boolean tcpNoDelay() {
        return this.reader.getBoolean(TCP_NO_DELAY, false);
    }

    public int acceptBacklog() {
        return this.reader.getInteger(ACCEPT_BACKLOG, 1024);
    }

    public boolean sslEnabled() {
        return this.reader.getBoolean(SSL_ENABLED, false);
    }

    public SslProtocol sslProtocol() {
        String protocol = this.reader.getString(SSL_PROTOCOL, DEFAULT_SSL_PROTOCOL).replace(".", "_");
        try {
            return SslProtocol.valueOf(protocol);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("unknown SSL protocol: " + protocol, new Object[]{e});
        }
    }

    public String sslTrustStorePath() {
        return this.reader.getString(SSL_TRUST_STORE_PATH, null);
    }

    public String sslTrustStorePassword() {
        return this.reader.getString(SSL_TRUST_STORE_PASSWORD, null);
    }

    public String sslKeyStorePath() {
        return this.reader.getString(SSL_KEY_STORE_PATH);
    }

    public String sslKeyStorePassword() {
        return this.reader.getString(SSL_KEY_STORE_PASSWORD, null);
    }

    public String sslKeyStoreKeyPassword() {
        return this.reader.getString(SSL_KEY_STORE_KEY_PASSWORD, null);
    }
}

