/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport;

import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.NettyConnection;
import io.atomix.catalyst.transport.NettyHandler;
import io.atomix.catalyst.transport.NettyTls;
import io.atomix.catalyst.transport.NettyTransport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.concurrent.ComposableFuture;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClient
implements Client {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyClient.class);
    private static final ByteBufAllocator ALLOCATOR = new PooledByteBufAllocator(true);
    private static final ChannelHandler FIELD_PREPENDER = new LengthFieldPrepender(2);
    private final NettyTransport transport;
    private final Map<Channel, NettyConnection> connections = new ConcurrentHashMap<Channel, NettyConnection>();

    public NettyClient(NettyTransport transport) {
        this.transport = Assert.notNull(transport, "transport");
    }

    @Override
    public CompletableFuture<Connection> connect(Address address) {
        Assert.notNull(address, "address");
        final ThreadContext context = ThreadContext.currentContextOrThrow();
        final ComposableFuture<Connection> future = new ComposableFuture<Connection>();
        LOGGER.info("Connecting to {}", (Object)address);
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)bootstrap.group(this.transport.eventLoopGroup())).channel(NioSocketChannel.class)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel channel) throws Exception {
                ChannelPipeline pipeline = channel.pipeline();
                if (NettyClient.this.transport.properties().sslEnabled()) {
                    pipeline.addFirst(new SslHandler(new NettyTls(NettyClient.this.transport.properties()).initSslEngine(true)));
                }
                pipeline.addLast(FIELD_PREPENDER);
                pipeline.addLast(new LengthFieldBasedFrameDecoder(65536, 0, 2, 0, 2));
                ChannelHandler[] channelHandlerArray = new ChannelHandler[1];
                channelHandlerArray[0] = new NettyHandler(NettyClient.this.connections, future::complete, context);
                pipeline.addLast(channelHandlerArray);
            }
        });
        bootstrap.option(ChannelOption.TCP_NODELAY, this.transport.properties().tcpNoDelay());
        bootstrap.option(ChannelOption.SO_KEEPALIVE, this.transport.properties().tcpKeepAlive());
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, this.transport.properties().connectTimeout());
        bootstrap.option(ChannelOption.ALLOCATOR, ALLOCATOR);
        if (this.transport.properties().sendBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_SNDBUF, this.transport.properties().sendBufferSize());
        }
        if (this.transport.properties().receiveBufferSize() != -1) {
            bootstrap.option(ChannelOption.SO_RCVBUF, this.transport.properties().receiveBufferSize());
        }
        bootstrap.connect(address.socketAddress()).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)channelFuture -> {
            if (channelFuture.isSuccess()) {
                LOGGER.info("Connected to {}", (Object)address);
            } else {
                context.execute(() -> future.completeExceptionally(channelFuture.cause()));
            }
        }));
        return future;
    }

    @Override
    public CompletableFuture<Void> close() {
        ThreadContext.currentContextOrThrow();
        int i = 0;
        CompletableFuture[] futures = new CompletableFuture[this.connections.size()];
        for (Connection connection : this.connections.values()) {
            futures[i++] = connection.close();
        }
        return CompletableFuture.allOf(futures);
    }
}

