/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.AbstractBuffer;
import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.BufferAllocator;
import io.atomix.catalyst.util.ReferencePool;

public abstract class PooledAllocator
implements BufferAllocator {
    private final ReferencePool<AbstractBuffer> pool;

    protected PooledAllocator(ReferencePool<AbstractBuffer> pool) {
        this.pool = pool;
    }

    protected abstract long maxCapacity();

    @Override
    public Buffer allocate() {
        return this.allocate(4096L, this.maxCapacity());
    }

    @Override
    public Buffer allocate(long capacity) {
        return this.allocate(capacity, this.maxCapacity());
    }

    @Override
    public Buffer allocate(long initialCapacity, long maxCapacity) {
        return this.pool.acquire().reset(0L, initialCapacity, maxCapacity).clear();
    }
}

