/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource.util;

import io.atomix.catalyst.util.Assert;
import io.atomix.resource.ResourceType;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ResourceRegistry {
    private final Map<Integer, ResourceType> resourceTypes = new ConcurrentHashMap<Integer, ResourceType>();

    public Collection<ResourceType> types() {
        return this.resourceTypes.values();
    }

    public ResourceRegistry register(ResourceType type) {
        Assert.notNull((Object)type, (String)"type");
        Assert.argNot((type.id() > Short.MAX_VALUE ? 1 : 0) != 0, (String)"resource ID must be less than %d", (Object[])new Object[]{(short)Short.MAX_VALUE});
        Assert.argNot((boolean)this.resourceTypes.containsKey(type.id()), (String)"a type with the ID %s already exists", (Object[])new Object[]{type.id()});
        this.resourceTypes.put(type.id(), type);
        return this;
    }

    public ResourceType lookup(int id) {
        return this.resourceTypes.get(id);
    }

    public String toString() {
        return String.format("%s%s", this.getClass().getSimpleName(), this.resourceTypes.values());
    }
}

