/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource.util;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.resource.util.ResourceOperation;
import java.util.Properties;

public final class ResourceCommand<T extends Command<U>, U>
extends ResourceOperation<T, U>
implements Command<U> {
    private Command.ConsistencyLevel consistency;

    public ResourceCommand() {
    }

    public ResourceCommand(T command, Command.ConsistencyLevel consistency) {
        super(command);
        this.consistency = consistency;
    }

    public Command.ConsistencyLevel consistency() {
        Command.ConsistencyLevel consistency = ((Command)this.operation).consistency();
        return consistency != null ? consistency : this.consistency;
    }

    public Command.CompactionMode compaction() {
        return ((Command)this.operation).compaction();
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeByte(this.consistency.ordinal());
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.consistency = Command.ConsistencyLevel.values()[buffer.readByte()];
    }

    @Override
    public String toString() {
        return String.format("%s[command=%s, consistency=%s]", this.getClass().getSimpleName(), this.operation, this.consistency());
    }

    public static class Delete
    implements Command<Void>,
    CatalystSerializable {
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }

        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }

    public static class Config
    implements Query<Properties>,
    CatalystSerializable {
        public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        }

        public void readObject(BufferInput<?> buffer, Serializer serializer) {
        }
    }
}

