/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.manager;

import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.PropertiesReader;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.manager.options.ServerOptions;
import io.atomix.manager.state.ResourceManagerException;
import io.atomix.manager.state.ResourceManagerState;
import io.atomix.manager.util.ResourceManagerTypeResolver;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceFactory;
import io.atomix.resource.ResourceType;
import io.atomix.resource.util.ResourceRegistry;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public final class ResourceServer {
    private final CopycatServer server;

    public static Builder builder(String properties) {
        return ResourceServer.builder(PropertiesReader.load((String)properties).properties());
    }

    public static Builder builder(Properties properties) {
        ServerOptions serverProperties = new ServerOptions(properties);
        Collection<Address> servers = serverProperties.servers();
        return ResourceServer.builder(serverProperties.clientAddress(), serverProperties.serverAddress(), servers).withTransport(serverProperties.transport()).withStorage(Storage.builder().withStorageLevel(serverProperties.storageLevel()).withDirectory(serverProperties.storageDirectory()).withMaxSegmentSize(serverProperties.maxSegmentSize()).withMaxEntriesPerSegment(serverProperties.maxEntriesPerSegment()).withMaxSnapshotSize(serverProperties.maxSnapshotSize()).withRetainStaleSnapshots(serverProperties.retainStaleSnapshots()).withCompactionThreads(serverProperties.compactionThreads()).withMinorCompactionInterval(serverProperties.minorCompactionInterval()).withMajorCompactionInterval(serverProperties.majorCompactionInterval()).withCompactionThreshold(serverProperties.compactionThreshold()).build()).withSerializer(serverProperties.serializer()).withElectionTimeout(serverProperties.electionTimeout()).withHeartbeatInterval(serverProperties.heartbeatInterval()).withSessionTimeout(serverProperties.sessionTimeout());
    }

    public static Builder builder(Address address, Address ... members) {
        return ResourceServer.builder(address, Arrays.asList((Object[])Assert.notNull((Object)members, (String)"members")));
    }

    public static Builder builder(Address address, Collection<Address> members) {
        return new Builder(address, address, (Collection)Assert.notNull(members, (String)"members"));
    }

    public static Builder builder(Address clientAddress, Address serverAddress, Address ... members) {
        return ResourceServer.builder(clientAddress, serverAddress, Arrays.asList((Object[])Assert.notNull((Object)members, (String)"members")));
    }

    public static Builder builder(Address clientAddress, Address serverAddress, Collection<Address> members) {
        return new Builder(clientAddress, serverAddress, (Collection)Assert.notNull(members, (String)"members"));
    }

    public ResourceServer(CopycatServer server) {
        this.server = (CopycatServer)Assert.notNull((Object)server, (String)"server");
    }

    public ThreadContext context() {
        return this.server.context();
    }

    public Serializer serializer() {
        return this.server.serializer();
    }

    public CopycatServer server() {
        return this.server;
    }

    public CompletableFuture<ResourceServer> start() {
        return this.server.start().thenApply(v -> this);
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }

    public CompletableFuture<Void> stop() {
        return this.server.stop();
    }

    public static class Builder
    implements io.atomix.catalyst.util.Builder<ResourceServer> {
        private static final String SERVER_NAME = "atomix";
        private final CopycatServer.Builder builder;
        private final ResourceRegistry registry = new ResourceRegistry();

        private Builder(Address clientAddress, Address serverAddress, Collection<Address> members) {
            this.builder = CopycatServer.builder((Address)clientAddress, (Address)serverAddress, members).withName(SERVER_NAME);
        }

        public Builder withTransport(Transport transport) {
            this.builder.withTransport(transport);
            return this;
        }

        public Builder withClientTransport(Transport transport) {
            this.builder.withClientTransport(transport);
            return this;
        }

        public Builder withServerTransport(Transport transport) {
            this.builder.withServerTransport(transport);
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.builder.withSerializer(serializer);
            return this;
        }

        public Builder withStorage(Storage storage) {
            this.builder.withStorage(storage);
            return this;
        }

        public Builder withElectionTimeout(Duration electionTimeout) {
            this.builder.withElectionTimeout(electionTimeout);
            return this;
        }

        public Builder withHeartbeatInterval(Duration heartbeatInterval) {
            this.builder.withHeartbeatInterval(heartbeatInterval);
            return this;
        }

        public Builder withSessionTimeout(Duration sessionTimeout) {
            this.builder.withSessionTimeout(sessionTimeout);
            return this;
        }

        public Builder withResourceTypes(Class<? extends Resource<?>> ... types) {
            return this.withResourceTypes(Arrays.asList(types).stream().map(ResourceType::new).collect(Collectors.toList()));
        }

        public Builder withResourceTypes(ResourceType ... types) {
            return this.withResourceTypes(Arrays.asList(types));
        }

        public Builder withResourceTypes(Collection<ResourceType> types) {
            types.forEach(this.registry::register);
            return this;
        }

        public Builder addResourceType(Class<? extends Resource<?>> type) {
            return this.addResourceType(new ResourceType(type));
        }

        public Builder addResourceType(ResourceType type) {
            this.registry.register(type);
            return this;
        }

        public ResourceServer build() {
            CopycatServer server = this.builder.withStateMachine(ResourceManagerState::new).build();
            server.serializer().resolve(new SerializableTypeResolver[]{new ResourceManagerTypeResolver()});
            for (ResourceType type : this.registry.types()) {
                try {
                    ((ResourceFactory)type.factory().newInstance()).createSerializableTypeResolver().resolve(server.serializer().registry());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ResourceManagerException(e);
                }
            }
            return new ResourceServer(server);
        }
    }
}

