/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.manager;

import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.ConfigurationException;
import io.atomix.catalyst.util.PropertiesReader;
import io.atomix.catalyst.util.concurrent.Futures;
import io.atomix.catalyst.util.concurrent.ThreadContext;
import io.atomix.copycat.Query;
import io.atomix.copycat.client.ConnectionStrategies;
import io.atomix.copycat.client.ConnectionStrategy;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.copycat.client.RecoveryStrategies;
import io.atomix.copycat.client.RecoveryStrategy;
import io.atomix.copycat.client.RetryStrategies;
import io.atomix.copycat.client.RetryStrategy;
import io.atomix.copycat.client.ServerSelectionStrategies;
import io.atomix.copycat.client.ServerSelectionStrategy;
import io.atomix.manager.ResourceManager;
import io.atomix.manager.options.ClientOptions;
import io.atomix.manager.state.GetResourceKeys;
import io.atomix.manager.state.ResourceExists;
import io.atomix.manager.state.ResourceManagerException;
import io.atomix.manager.util.ResourceManagerTypeResolver;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceFactory;
import io.atomix.resource.ResourceType;
import io.atomix.resource.util.InstanceClient;
import io.atomix.resource.util.ResourceInstance;
import io.atomix.resource.util.ResourceRegistry;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ResourceClient
implements ResourceManager<ResourceClient> {
    final CopycatClient client;
    private final Map<Class<? extends Resource<?>>, ResourceType> types = new ConcurrentHashMap();
    private final Map<String, Resource<?>> instances = new HashMap();
    private final Map<String, CompletableFuture> futures = new HashMap<String, CompletableFuture>();

    public static Builder builder(String properties) {
        return ResourceClient.builder(PropertiesReader.load((String)properties).properties());
    }

    public static Builder builder(Properties properties) {
        ClientOptions clientProperties = new ClientOptions(properties);
        return ResourceClient.builder(clientProperties.servers()).withTransport(clientProperties.transport()).withSerializer(clientProperties.serializer());
    }

    public static Builder builder(Address ... members) {
        return new Builder(Arrays.asList((Object[])Assert.notNull((Object)members, (String)"members")));
    }

    public static Builder builder(Collection<Address> members) {
        return new Builder(members);
    }

    public ResourceClient(CopycatClient client) {
        this.client = (CopycatClient)Assert.notNull((Object)client, (String)"client");
    }

    public CopycatClient client() {
        return this.client;
    }

    @Override
    public ThreadContext context() {
        return this.client.context();
    }

    @Override
    public Serializer serializer() {
        return this.client.serializer();
    }

    @Override
    public final ResourceType type(Class<? extends Resource<?>> type) {
        return this.types.computeIfAbsent(type, ResourceType::new);
    }

    @Override
    public CompletableFuture<Boolean> exists(String key) {
        return this.client.submit((Query)new ResourceExists(key));
    }

    @Override
    public CompletableFuture<Set<String>> keys() {
        return this.client.submit((Query)new GetResourceKeys());
    }

    @Override
    public <T extends Resource> CompletableFuture<Set<String>> keys(Class<? super T> type) {
        return this.keys(this.type(type));
    }

    @Override
    public CompletableFuture<Set<String>> keys(ResourceType type) {
        return this.client.submit((Query)new GetResourceKeys(((ResourceType)Assert.notNull((Object)type, (String)"type")).id()));
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, Class<? super T> type) {
        return this.getResource(key, this.type(type), new Resource.Config(), new Resource.Options());
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, Class<? super T> type, Resource.Config config) {
        return this.getResource(key, this.type(type), config, new Resource.Options());
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, Class<? super T> type, Resource.Options options) {
        return this.getResource(key, this.type(type), new Resource.Config(), options);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, Class<? super T> type, Resource.Config config, Resource.Options options) {
        return this.getResource(key, this.type(type), config, options);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, ResourceType type) {
        return this.getResource(key, type, new Resource.Config(), new Resource.Options());
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, ResourceType type, Resource.Config config) {
        return this.getResource(key, type, config, new Resource.Options());
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, ResourceType type, Resource.Options options) {
        return this.getResource(key, type, new Resource.Config(), options);
    }

    @Override
    public synchronized <T extends Resource> CompletableFuture<T> getResource(String key, ResourceType type, Resource.Config config, Resource.Options options) {
        Assert.notNull((Object)key, (String)"key");
        Assert.notNull((Object)type, (String)"type");
        Assert.notNull((Object)config, (String)"config");
        Assert.notNull((Object)options, (String)"options");
        Resource check = this.instances.get(key);
        if (check == null) {
            ResourceInstance instance = new ResourceInstance(key, type, (Properties)config, this::close);
            InstanceClient client = new InstanceClient(instance, this.client);
            try {
                check = ((ResourceFactory)type.factory().newInstance()).createInstance((CopycatClient)client, (Properties)options);
                this.instances.put(key, check);
            }
            catch (IllegalAccessException | InstantiationException e) {
                return Futures.exceptionalFuture((Throwable)e);
            }
        }
        if (check.type().id() != type.id()) {
            return Futures.exceptionalFuture((Throwable)new IllegalArgumentException("inconsistent resource type: " + type));
        }
        Resource resource = check;
        CompletableFuture future = this.futures.get(key);
        if (future == null) {
            future = resource.open();
            this.futures.put(key, future);
        }
        return future;
    }

    private synchronized void close(ResourceInstance instance) {
        this.instances.remove(instance.key());
        this.futures.remove(instance.key());
    }

    public CopycatClient.State state() {
        return this.client.state();
    }

    public CompletableFuture<ResourceClient> connect() {
        return this.client.connect().thenApply(v -> this);
    }

    public CompletableFuture<Void> close() {
        CompletableFuture[] futures = new CompletableFuture[this.instances.size()];
        int i = 0;
        for (Resource<?> instance : this.instances.values()) {
            futures[i++] = instance.close();
        }
        return CompletableFuture.allOf(futures).thenCompose(v -> this.client.close());
    }

    public String toString() {
        return String.format("%s[session=%s]", this.getClass().getSimpleName(), this.client.session());
    }

    public static class Builder
    implements io.atomix.catalyst.util.Builder<ResourceClient> {
        private final ResourceRegistry registry = new ResourceRegistry();
        private CopycatClient.Builder clientBuilder;
        private Transport transport;

        protected Builder(Collection<Address> members) {
            this.clientBuilder = CopycatClient.builder(members).withServerSelectionStrategy((ServerSelectionStrategy)ServerSelectionStrategies.ANY).withConnectionStrategy((ConnectionStrategy)ConnectionStrategies.FIBONACCI_BACKOFF).withRecoveryStrategy((RecoveryStrategy)RecoveryStrategies.RECOVER).withRetryStrategy((RetryStrategy)RetryStrategies.FIBONACCI_BACKOFF);
        }

        public Builder withTransport(Transport transport) {
            this.clientBuilder.withTransport(transport);
            this.transport = transport;
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.clientBuilder.withSerializer(serializer);
            return this;
        }

        public Builder withResourceTypes(Class<? extends Resource<?>> ... types) {
            return this.withResourceTypes(Arrays.asList(types).stream().map(ResourceType::new).collect(Collectors.toList()));
        }

        public Builder withResourceTypes(ResourceType ... types) {
            return this.withResourceTypes(Arrays.asList(types));
        }

        public Builder withResourceTypes(Collection<ResourceType> types) {
            types.forEach(this.registry::register);
            return this;
        }

        public Builder addResourceType(Class<? extends Resource<?>> type) {
            return this.addResourceType(new ResourceType(type));
        }

        public Builder addResourceType(ResourceType type) {
            this.registry.register(type);
            return this;
        }

        public ResourceClient build() {
            if (this.transport == null) {
                try {
                    this.transport = (Transport)Class.forName("io.atomix.catalyst.transport.NettyTransport").newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new ConfigurationException("transport not configured", new Object[0]);
                }
            }
            CopycatClient client = this.clientBuilder.build();
            client.serializer().resolve(new SerializableTypeResolver[]{new ResourceManagerTypeResolver()});
            for (ResourceType type : this.registry.types()) {
                try {
                    ((ResourceFactory)type.factory().newInstance()).createSerializableTypeResolver().resolve(client.serializer().registry());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ResourceManagerException(e);
                }
            }
            return new ResourceClient(client);
        }
    }
}

