/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.impl.AbstractClientConnection;
import io.atomix.cluster.messaging.impl.ProtocolRequest;
import io.netty.channel.Channel;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;

final class RemoteClientConnection
extends AbstractClientConnection {
    private final Channel channel;

    RemoteClientConnection(ScheduledExecutorService executorService, Channel channel) {
        super(executorService);
        this.channel = channel;
    }

    @Override
    public CompletableFuture<Void> sendAsync(ProtocolRequest message) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.channel.writeAndFlush((Object)message).addListener(channelFuture -> {
            if (!channelFuture.isSuccess()) {
                future.completeExceptionally(channelFuture.cause());
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<byte[]> sendAndReceive(ProtocolRequest message, Duration timeout) {
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        AbstractClientConnection.Callback callback = new AbstractClientConnection.Callback(message.id(), message.subject(), timeout, future);
        this.channel.writeAndFlush((Object)message).addListener(channelFuture -> {
            if (!channelFuture.isSuccess()) {
                callback.completeExceptionally(channelFuture.cause());
            }
        });
        return future;
    }
}

