/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import com.google.common.base.Preconditions;
import io.atomix.storage.buffer.ByteBufferBuffer;
import io.atomix.storage.buffer.DirectBytes;
import io.atomix.utils.memory.Memory;

public class DirectBuffer
extends ByteBufferBuffer {
    public static DirectBuffer allocate() {
        return DirectBuffer.allocate(4096, Integer.MAX_VALUE);
    }

    public static DirectBuffer allocate(int initialCapacity) {
        return DirectBuffer.allocate(initialCapacity, Integer.MAX_VALUE);
    }

    public static DirectBuffer allocate(int initialCapacity, int maxCapacity) {
        Preconditions.checkArgument((initialCapacity <= maxCapacity ? 1 : 0) != 0, (Object)"initial capacity cannot be greater than maximum capacity");
        return new DirectBuffer(DirectBytes.allocate((int)Math.min(Memory.Util.toPow2((int)initialCapacity), Integer.MAX_VALUE)), 0, initialCapacity, maxCapacity);
    }

    protected DirectBuffer(DirectBytes bytes, int offset, int initialCapacity, int maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity, null);
    }

    @Override
    public DirectBuffer duplicate() {
        return new DirectBuffer((DirectBytes)this.bytes, this.offset(), this.capacity(), this.maxCapacity());
    }
}

