/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.storage.buffer;

import com.google.common.base.Preconditions;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.NativeBuffer;
import io.atomix.storage.buffer.UnsafeMappedBytes;
import io.atomix.utils.concurrent.ReferenceManager;
import io.atomix.utils.memory.MappedMemory;
import io.atomix.utils.memory.MappedMemoryAllocator;
import io.atomix.utils.memory.Memory;
import java.io.File;
import java.nio.channels.FileChannel;

public class UnsafeMappedBuffer
extends NativeBuffer {
    private static final int DEFAULT_INITIAL_CAPACITY = 0x1000000;

    public static UnsafeMappedBuffer allocate(File file) {
        return UnsafeMappedBuffer.allocate(file, MappedMemoryAllocator.DEFAULT_MAP_MODE, 0x1000000, Integer.MAX_VALUE);
    }

    public static UnsafeMappedBuffer allocate(File file, FileChannel.MapMode mode) {
        return UnsafeMappedBuffer.allocate(file, mode, 0x1000000, Integer.MAX_VALUE);
    }

    public static UnsafeMappedBuffer allocate(File file, int capacity) {
        return UnsafeMappedBuffer.allocate(file, MappedMemoryAllocator.DEFAULT_MAP_MODE, capacity, capacity);
    }

    public static UnsafeMappedBuffer allocate(File file, FileChannel.MapMode mode, int capacity) {
        return UnsafeMappedBuffer.allocate(file, mode, capacity, capacity);
    }

    public static UnsafeMappedBuffer allocate(File file, int initialCapacity, int maxCapacity) {
        return UnsafeMappedBuffer.allocate(file, MappedMemoryAllocator.DEFAULT_MAP_MODE, initialCapacity, maxCapacity);
    }

    public static UnsafeMappedBuffer allocate(File file, FileChannel.MapMode mode, int initialCapacity, int maxCapacity) {
        Preconditions.checkNotNull((Object)file, (Object)"file cannot be null");
        Preconditions.checkNotNull((Object)mode, (Object)"mode cannot be null");
        Preconditions.checkArgument((initialCapacity <= maxCapacity ? 1 : 0) != 0, (Object)"initial capacity cannot be greater than maximum capacity");
        return new UnsafeMappedBuffer(new UnsafeMappedBytes(file, MappedMemory.allocate((File)file, (FileChannel.MapMode)mode, (int)((int)Math.min(Memory.Util.toPow2((int)initialCapacity), (long)maxCapacity)))), 0, initialCapacity, maxCapacity);
    }

    protected UnsafeMappedBuffer(UnsafeMappedBytes bytes, ReferenceManager<Buffer> referenceManager) {
        super(bytes, referenceManager);
    }

    UnsafeMappedBuffer(UnsafeMappedBytes bytes, int offset, int initialCapacity, int maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity);
    }

    @Override
    public UnsafeMappedBuffer duplicate() {
        return new UnsafeMappedBuffer((UnsafeMappedBytes)this.bytes, this.offset(), this.capacity(), this.maxCapacity());
    }

    public void delete() {
        ((UnsafeMappedBytes)this.bytes).delete();
    }
}

