/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.rabbitmq;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.ConnectionFactoryConfigurator;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public class AloConnectionFactory
extends ConnectionFactory {
    public static final String HOSTS = "hosts";
    public static final String VHOST = "vhost";
    public static final String SSL = "ssl";
    public static final String DISABLED = "disabled";
    private final List<Address> addresses;

    public AloConnectionFactory(List<Address> addresses) {
        this.addresses = addresses;
    }

    public static AloConnectionFactory from(Map<String, ?> properties) {
        List<Address> addresses = AloConnectionFactory.extractAddresses(properties);
        Map<String, String> configuratorProperties = AloConnectionFactory.createConfiguratorProperties(properties);
        configuratorProperties.remove("host");
        configuratorProperties.remove("port");
        AloConnectionFactory connectionFactory = new AloConnectionFactory(addresses);
        ConnectionFactoryConfigurator.load((ConnectionFactory)connectionFactory, configuratorProperties, (String)"");
        return connectionFactory;
    }

    public Connection newConnection() throws IOException, TimeoutException {
        return this.newConnection(this.addresses);
    }

    public Connection newConnection(String connectionName) throws IOException, TimeoutException {
        return this.newConnection(this.addresses, connectionName);
    }

    public Connection newConnection(ExecutorService executor) throws IOException, TimeoutException {
        return this.newConnection(executor, this.addresses);
    }

    public Connection newConnection(ExecutorService executor, String connectionName) throws IOException, TimeoutException {
        return this.newConnection(executor, this.addresses, connectionName);
    }

    public String getHost() {
        return this.addresses.get(0).getHost();
    }

    public void setHost(String host) {
        throw new UnsupportedOperationException("Cannot set host on multi-address ConnectionFactory");
    }

    public int getPort() {
        return this.addresses.get(0).getPort();
    }

    public void setPort(int port) {
        throw new UnsupportedOperationException("Cannot set port on multi-address ConnectionFactory");
    }

    private static List<Address> extractAddresses(Map<String, ?> properties) {
        String hosts = AloConnectionFactory.extractHosts(properties);
        int fallbackPort = Optional.ofNullable(properties.get("port")).map(port -> Integer.parseInt(port.toString())).orElse(-1);
        return Arrays.stream(Address.parseAddresses((String)hosts)).map(address -> address.getPort() == -1 && fallbackPort != -1 ? new Address(address.getHost(), fallbackPort) : address).collect(Collectors.toList());
    }

    private static String extractHosts(Map<String, ?> properties) {
        Object host = properties.get("host");
        return Objects.toString(host == null ? properties.get(HOSTS) : host, "localhost");
    }

    private static Map<String, String> createConfiguratorProperties(Map<String, ?> properties) {
        Map<String, String> configuration = properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Objects.toString(entry.getValue())));
        if (!configuration.containsKey("virtual.host") && configuration.containsKey(VHOST)) {
            configuration.put("virtual.host", configuration.remove(VHOST));
        }
        String ssl = configuration.getOrDefault(SSL, DISABLED);
        if (!configuration.containsKey("ssl.enabled") && !ssl.equals(DISABLED)) {
            configuration.put("ssl.enabled", "true");
            configuration.put("ssl.algorithm", ssl);
        }
        return configuration;
    }
}

