/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import io.atleon.core.AloDecorator;
import io.atleon.core.AloDecoratorConfig;
import io.atleon.rabbitmq.AloRabbitMQMessageDecorator;
import io.atleon.rabbitmq.RabbitMQMessage;
import io.atleon.util.ConfigLoading;
import io.atleon.util.Configurable;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class RabbitMQConfig {
    private final ConnectionFactory connectionFactory;
    private final Map<String, Object> properties;

    public RabbitMQConfig(ConnectionFactory connectionFactory, Map<String, Object> properties) {
        this.connectionFactory = connectionFactory;
        this.properties = properties;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public <T> Optional<AloDecorator<RabbitMQMessage<T>>> loadAloDecorator(String descriptorsProperty) {
        return AloDecoratorConfig.load(AloRabbitMQMessageDecorator.class, this.properties, (String)descriptorsProperty);
    }

    public <T extends Configurable> T loadConfiguredOrThrow(String property) {
        return (T)ConfigLoading.loadConfiguredOrThrow(this.properties, (String)property);
    }

    public <T> Optional<T> load(String property, Function<? super String, T> parser) {
        return ConfigLoading.load(this.properties, (String)property, parser);
    }
}

