/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.rabbitmq;

import com.rabbitmq.client.ConnectionFactory;
import io.atleon.rabbitmq.Configurable;
import io.atleon.util.ConfigLoading;
import io.atleon.util.Instantiation;
import io.atleon.util.TypeResolution;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RabbitMQConfig {
    private final ConnectionFactory connectionFactory;
    private final Map<String, Object> properties;

    public RabbitMQConfig(ConnectionFactory connectionFactory, Map<String, Object> properties) {
        this.connectionFactory = connectionFactory;
        this.properties = properties;
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public <T> Optional<T> load(String property, Function<? super String, T> parser) {
        return ConfigLoading.load(this.properties, (String)property, parser);
    }

    public <T extends Configurable> List<T> loadListOfConfigured(String property) {
        List listOfConfigured = ConfigLoading.loadCollection(this.properties, (String)property, x$0 -> (Configurable)Instantiation.one((String)x$0, (Object[])new Object[0]), Collectors.toList()).orElseGet(Collections::emptyList);
        listOfConfigured.forEach(interceptor -> interceptor.configure(this.properties));
        return listOfConfigured;
    }

    public <T extends Configurable> Optional<T> loadConfigured(String property) {
        return ConfigLoading.load(this.properties, (String)property, TypeResolution::classForQualifiedName).map(this::createConfigured);
    }

    public <T extends Configurable> T loadConfiguredOrThrow(String property) {
        return this.createConfigured((Class)ConfigLoading.loadOrThrow(this.properties, (String)property, TypeResolution::classForQualifiedName));
    }

    private <T extends Configurable> T createConfigured(Class<? extends T> configurableClass) {
        Configurable configurable = (Configurable)Instantiation.one(configurableClass, (Object[])new Object[0]);
        configurable.configure(this.properties);
        return (T)configurable;
    }
}

