/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.rabbitmq;

import com.rabbitmq.client.AMQP;
import io.atleon.rabbitmq.RabbitMQMessage;
import io.atleon.rabbitmq.RabbitMQMessageCreator;
import java.util.UUID;

public abstract class AbstractRabbitMQMessageCreator<T>
implements RabbitMQMessageCreator<T> {
    private final AMQP.BasicProperties initialProperties;

    public AbstractRabbitMQMessageCreator(AMQP.BasicProperties initialProperties) {
        this.initialProperties = initialProperties;
    }

    @Override
    public RabbitMQMessage<T> apply(T t) {
        return new RabbitMQMessage<T>(this.extractExchange(t), this.extractRoutingKey(t), this.createMessagePropertiesBuilder(t).build(), t);
    }

    protected abstract String extractExchange(T var1);

    protected abstract String extractRoutingKey(T var1);

    protected AMQP.BasicProperties.Builder createMessagePropertiesBuilder(T t) {
        return this.initialProperties.builder().messageId(UUID.randomUUID().toString());
    }
}

