/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.test;

import dasniko.testcontainers.keycloak.KeycloakContainer;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakTestResourceWithoutRoles
implements QuarkusTestResourceLifecycleManager {
    private static final Logger log = LoggerFactory.getLogger(KeycloakTestResourceWithoutRoles.class);
    private KeycloakContainer container;

    public Map<String, String> start() {
        log.info("Starting Keycloak Test Container");
        this.container = new KeycloakContainer().withRealmImportFile("test-realm.json");
        this.container.start();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("app.keycloak.url", this.container.getAuthServerUrl());
        props.put("app.keycloak.realm", "apicurio");
        props.put("app.authn.enabled", "true");
        props.put("app.authn.client-secret", "test1");
        props.put("tenant-manager.auth.enabled", "true");
        props.put("tenant-manager.keycloak.url", this.container.getAuthServerUrl());
        props.put("tenant-manager.keycloak.realm", "apicurio");
        props.put("tenant-manager.authz.enabled", "true");
        return props;
    }

    public void stop() {
        log.info("Stopping Keycloak Test Container");
        this.container.stop();
        this.container.close();
    }
}

