/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.test;

import dasniko.testcontainers.keycloak.KeycloakContainer;
import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakTestResource
implements QuarkusTestResourceLifecycleManager {
    private static final Logger log = LoggerFactory.getLogger(KeycloakTestResource.class);
    private KeycloakContainer container;
    String testUsername = "sr-test-user";
    String testPassword = "sr-test-password";

    public Map<String, String> start() {
        log.info("Starting Keycloak Test Container");
        this.container = new KeycloakContainer().withRealmImportFile("test-realm.json");
        this.container.start();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("registry.keycloak.url", this.container.getAuthServerUrl());
        props.put("registry.keycloak.realm", "registry");
        props.put("registry.auth.enabled", "true");
        props.put("registry.auth.client-secret", "test1");
        props.put("registry.auth.role-based-authorization", "true");
        props.put("registry.auth.owner-only-authorization", "true");
        props.put("registry.auth.admin-override.enabled", "true");
        this.createTestUser();
        return props;
    }

    private void createTestUser() {
        Keycloak keycloakAdminClient = KeycloakBuilder.builder().serverUrl(this.container.getAuthServerUrl()).realm("master").clientId("admin-cli").username(this.container.getAdminUsername()).password(this.container.getAdminPassword()).build();
        UserRepresentation userRepresentation = new UserRepresentation();
        userRepresentation.setUsername(this.testUsername);
        userRepresentation.setEnabled(Boolean.valueOf(true));
        userRepresentation.setEmailVerified(Boolean.valueOf(true));
        CredentialRepresentation credentialRepresentation = new CredentialRepresentation();
        credentialRepresentation.setType("password");
        credentialRepresentation.setValue(this.testPassword);
        credentialRepresentation.setTemporary(Boolean.valueOf(false));
        userRepresentation.setCredentials(Collections.singletonList(credentialRepresentation));
        keycloakAdminClient.realm("registry").users().create(userRepresentation);
        RoleRepresentation adminRoleRepresentation = keycloakAdminClient.realm("registry").roles().get("sr-admin").toRepresentation();
        UserRepresentation user = (UserRepresentation)keycloakAdminClient.realm("registry").users().search(this.testUsername).get(0);
        keycloakAdminClient.realm("registry").users().get(user.getId()).roles().realmLevel().add(List.of(adminRoleRepresentation));
    }

    public void stop() {
        log.info("Stopping Keycloak Test Container");
        this.container.stop();
        this.container.close();
    }
}

