/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.testimpl;

import io.annot8.common.implementations.factories.GroupBuilderFactory;
import io.annot8.core.annotations.Annotation;
import io.annot8.core.annotations.Group;
import io.annot8.core.properties.Properties;
import io.annot8.core.references.AnnotationReference;
import io.annot8.testing.testimpl.TestAnnotationReference;
import io.annot8.testing.testimpl.TestGroup;
import io.annot8.testing.testimpl.TestProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class TestGroupBuilder
implements Group.Builder {
    private final Map<AnnotationReference, String> annotations = new HashMap<AnnotationReference, String>();
    private final TestProperties properties = new TestProperties();
    private String id = UUID.randomUUID().toString();
    private String type = "testGroupType";

    public static GroupBuilderFactory<Group> factory() {
        return (item, store) -> new TestGroupBuilder();
    }

    public Group.Builder withAnnotation(String role, Annotation annotation) {
        this.annotations.put(new TestAnnotationReference(annotation), role);
        return this;
    }

    public Group save() {
        TestGroup group = new TestGroup(this.id, this.type);
        group.setProperties(this.properties);
        group.setAnnotations(this.annotations);
        return group;
    }

    public Group.Builder from(Group from) {
        this.id = from.getId();
        this.type = from.getType();
        this.properties.add(from.getProperties().getAll());
        from.getAnnotations().forEach((key, value) -> value.forEach(a -> this.annotations.put(new TestAnnotationReference((Annotation)a), (String)key)));
        return this;
    }

    public Group.Builder withId(String id) {
        this.id = id;
        return this;
    }

    public Group.Builder newId() {
        this.id = null;
        return this;
    }

    public Group.Builder withProperty(String key, Object value) {
        this.properties.set(key, value);
        return this;
    }

    public Group.Builder withoutProperty(String key, Object value) {
        Optional opt = this.properties.get(key);
        if (opt.isPresent() && opt.get().equals(value)) {
            this.properties.remove(key);
        }
        return this;
    }

    public Group.Builder withoutProperty(String key) {
        this.properties.remove(key);
        return this;
    }

    public Group.Builder withProperties(Properties properties) {
        this.properties.add(properties.getAll());
        return this;
    }

    public Group.Builder withType(String type) {
        this.type = type;
        return this;
    }
}

