/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.testing.testimpl;

import io.annot8.common.implementations.delegates.DelegateAnnotationBuilder;
import io.annot8.common.implementations.factories.AnnotationBuilderFactory;
import io.annot8.core.annotations.Annotation;
import io.annot8.core.data.Content;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.stores.AnnotationStore;
import io.annot8.testing.testimpl.TestAnnotationBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class TestAnnotationStore
implements AnnotationStore {
    private final Map<String, Annotation> annotations = new ConcurrentHashMap<String, Annotation>();
    private final AnnotationBuilderFactory annotationBuilderFactory;
    private String contentId;

    public TestAnnotationStore() {
        this("testContentName");
    }

    public TestAnnotationStore(String contentId) {
        this(contentId, TestAnnotationBuilder.factory());
    }

    public TestAnnotationStore(String contentId, AnnotationBuilderFactory annotationBuilderFactory) {
        this.contentId = contentId;
        this.annotationBuilderFactory = annotationBuilderFactory;
    }

    public TestAnnotationStore(Content<?> content) {
        this(content.getName());
    }

    public Annotation.Builder getBuilder() {
        return new DelegateAnnotationBuilder(this.annotationBuilderFactory.create(this.contentId, (AnnotationStore)this)){

            public Annotation save() throws IncompleteException {
                return TestAnnotationStore.this.save(super.save());
            }
        };
    }

    public void setContentId(String contentName) {
        this.contentId = contentName;
    }

    public Annotation save(Annotation.Builder annotationBuilder) throws IncompleteException {
        Annotation annotation = (Annotation)annotationBuilder.save();
        return this.save(annotation);
    }

    public Annotation save(Annotation annotation) {
        this.annotations.put(annotation.getId(), annotation);
        return annotation;
    }

    public void delete(Annotation annotation) {
        this.annotations.remove(annotation.getId());
    }

    public Stream<Annotation> getAll() {
        return this.annotations.values().stream();
    }

    public Optional<Annotation> getById(String annotationId) {
        return Optional.ofNullable(this.annotations.get(annotationId));
    }
}

