/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.implementations.support.properties;

import io.annot8.api.properties.ImmutableProperties;
import io.annot8.api.properties.Properties;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class MapImmutableProperties
implements ImmutableProperties {
    private final Map<String, Object> properties;

    private MapImmutableProperties(Map<String, Object> properties) {
        this.properties = Map.copyOf(properties);
    }

    public Map<String, Object> getAll() {
        return this.properties;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.properties.entrySet().stream().map(e -> (String)e.getKey() + "=" + e.getValue()).collect(Collectors.joining(", ")) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Properties)) {
            return false;
        }
        Properties p = (Properties)o;
        return Objects.equals(this.properties, p.getAll());
    }

    public static class Builder
    implements ImmutableProperties.Builder {
        private final Map<String, Object> properties = new HashMap<String, Object>();

        public ImmutableProperties.Builder from(Properties from) {
            this.properties.clear();
            from.getAll().forEach(this.properties::put);
            return this;
        }

        public ImmutableProperties.Builder withProperty(String key, Object value) {
            this.properties.put(key, value);
            return this;
        }

        public ImmutableProperties.Builder withPropertyIfPresent(String key, Optional<?> value) {
            value.ifPresent(o -> this.properties.put(key, o));
            return this;
        }

        public Builder withoutProperty(String key, Object value) {
            Object val = this.properties.get(key);
            if (Objects.equals(value, val)) {
                this.properties.remove(key);
            }
            return this;
        }

        public Builder withoutProperty(String key) {
            this.properties.remove(key);
            return this;
        }

        public ImmutableProperties.Builder withProperties(Properties properties) {
            properties.getAll().forEach(this.properties::put);
            return this;
        }

        public ImmutableProperties save() {
            return new MapImmutableProperties(this.properties);
        }
    }
}

