/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.implementations.support.content;

import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.exceptions.IncompleteException;
import io.annot8.api.properties.ImmutableProperties;
import io.annot8.api.properties.Properties;
import io.annot8.implementations.support.properties.MapImmutableProperties;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;

public abstract class AbstractContentBuilder<D, C extends Content<D>>
implements Content.Builder<C, D> {
    private final Item item;
    private final ImmutableProperties.Builder properties = new MapImmutableProperties.Builder();
    private String id;
    private String description;
    private Supplier<D> data;

    protected AbstractContentBuilder(Item item) {
        this.item = item;
    }

    protected Item getItem() {
        return this.item;
    }

    public Content.Builder<C, D> withId(String id) {
        this.id = id;
        return this;
    }

    public Content.Builder<C, D> withDescription(String description) {
        this.description = description;
        return this;
    }

    public Content.Builder<C, D> withData(Supplier<D> data) {
        this.data = data;
        return this;
    }

    public Content.Builder<C, D> from(C from) {
        return this;
    }

    public Content.Builder<C, D> withProperty(String key, Object value) {
        this.properties.withProperty(key, value);
        return this;
    }

    public Content.Builder<C, D> withPropertyIfPresent(String key, Optional<?> value) {
        value.ifPresent(o -> this.properties.withProperty(key, o));
        return this;
    }

    public Content.Builder<C, D> withProperties(Properties properties) {
        this.properties.withProperties(properties);
        return this;
    }

    public Content.Builder<C, D> withoutProperty(String key, Object value) {
        this.properties.withoutProperty(key, value);
        return this;
    }

    public Content.Builder<C, D> withoutProperty(String key) {
        this.properties.withoutProperty(key);
        return this;
    }

    public C save() throws IncompleteException {
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
        }
        if (this.data == null) {
            throw new IncompleteException("Data supplier is required");
        }
        return this.create(this.id, this.description, (ImmutableProperties)this.properties.save(), this.data);
    }

    protected abstract C create(String var1, String var2, ImmutableProperties var3, Supplier<D> var4);
}

