/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.items.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import java.util.Optional;

@ComponentName(value="Filter Items by Property")
@ComponentDescription(value="Discard items that match a specified property")
@SettingsClass(value=Settings.class)
@ComponentTags(value={"item", "properties", "filter"})
public class FilterItemsByProperty
extends AbstractProcessorDescriptor<Processor, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().build();
    }

    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.getKey(), settings.getValue(), settings.isDiscardMatching());
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private String key = null;
        private Object value = null;
        private boolean discardMatching = true;

        public boolean validate() {
            return this.key != null;
        }

        @Description(value="The property key to match against")
        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        @Description(value="The property value to match against")
        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        @Description(value="If true, then matching items are discarded. Otherwise, non-matching items are discarded.")
        public boolean isDiscardMatching() {
            return this.discardMatching;
        }

        public void setDiscardMatching(boolean discardMatching) {
            this.discardMatching = discardMatching;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final String key;
        private final Object value;
        private final boolean discardMatching;

        public Processor(String key, Object value, boolean discardMatching) {
            this.key = key;
            this.value = value;
            this.discardMatching = discardMatching;
        }

        public ProcessorResponse process(Item item) {
            Optional match = item.getProperties().get(this.key);
            if (this.value == null) {
                if (this.discardMatching && match.isEmpty()) {
                    item.discard();
                } else if (!this.discardMatching && match.isPresent()) {
                    item.discard();
                }
            } else if (this.discardMatching) {
                if (match.isPresent() && match.get().equals(this.value)) {
                    item.discard();
                }
            } else if (match.isEmpty() || !match.get().equals(this.value)) {
                item.discard();
            }
            return ProcessorResponse.ok();
        }
    }
}

