/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.items.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.Text;
import javax.json.bind.annotation.JsonbCreator;
import javax.json.bind.annotation.JsonbProperty;

@ComponentName(value="Item Type by Parameter")
@ComponentDescription(value="Explicitly sets the Item type")
@SettingsClass(value=Settings.class)
public class ItemTypeByParameter
extends AbstractProcessorDescriptor<Processor, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).build();
    }

    public Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.getType());
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private final String type;

        @JsonbCreator
        public Settings(@JsonbProperty(value="type") String type) {
            this.type = type;
        }

        @Description(value="Value to set type to")
        public String getType() {
            return this.type;
        }

        public boolean validate() {
            return true;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final String type;

        public Processor(String type) {
            this.type = type;
        }

        public ProcessorResponse process(Item item) {
            if (this.type == null || this.type.isBlank()) {
                return ProcessorResponse.ok();
            }
            item.getProperties().set("subtype", (Object)this.type);
            return ProcessorResponse.ok();
        }
    }
}

