/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.sources;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.SourceResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.ItemFactory;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractSource;
import io.annot8.common.components.AbstractSourceDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.FileContent;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;

@ComponentName(value="Folder Source")
@ComponentDescription(value="Treat each folder as an item with each file in the folder content for the item.")
@SettingsClass(value=Settings.class)
public class FolderSource
extends AbstractSourceDescriptor<Source, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withCreatesContent(FileContent.class).build();
    }

    protected Source createComponent(Context context, Settings settings) {
        return new Source(settings);
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private List<Path> paths = new ArrayList<Path>();
        private List<String> extensions = new ArrayList<String>();
        private boolean recursive = true;

        public boolean validate() {
            return this.extensions != null && this.paths != null && !this.paths.isEmpty();
        }

        @Description(value="List of paths to process")
        public List<Path> getPaths() {
            return this.paths;
        }

        public void setPaths(List<Path> paths) {
            this.paths = paths;
        }

        @Description(value="List of file extensions to accept (accepts all files if no extensions are given)")
        public List<String> getExtensions() {
            return this.extensions;
        }

        public void setExtensions(List<String> extensions) {
            this.extensions = extensions.stream().map(String::toLowerCase).collect(Collectors.toList());
        }

        @Description(value="Should we process paths recursively?")
        public boolean isRecursive() {
            return this.recursive;
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }
    }

    public static class Source
    extends AbstractSource {
        private final Queue<Path> folders = new LinkedList<Path>();
        private final Settings settings;

        public Source(Settings settings) {
            this.settings = settings;
            if (settings.isRecursive()) {
                settings.getPaths().forEach(p -> {
                    try {
                        Files.walk(p, new FileVisitOption[0]).filter(f -> !p.equals(f)).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(this.folders::add);
                    }
                    catch (Exception e) {
                        this.log().error("Unable to read files recursively in path {}", p, (Object)e);
                    }
                });
            } else {
                settings.getPaths().forEach(p -> {
                    try {
                        Files.list(p).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(this.folders::add);
                    }
                    catch (Exception e) {
                        this.log().error("Unable to read files in path {}", p, (Object)e);
                    }
                });
            }
            this.log().info("{} folders to be processed", (Object)this.folders.size());
        }

        private boolean acceptExtension(Path p) {
            List<String> extensions = this.settings.getExtensions();
            if (extensions.isEmpty()) {
                return true;
            }
            return extensions.contains(com.google.common.io.Files.getFileExtension((String)p.toString()).toLowerCase());
        }

        public SourceResponse read(ItemFactory itemFactory) {
            if (this.folders.isEmpty()) {
                return SourceResponse.done();
            }
            Path p = this.folders.poll();
            this.log().info("Processing {}", (Object)p);
            itemFactory.create(item -> {
                item.getProperties().set("source", (Object)p);
                try {
                    Files.list(p).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(this::acceptExtension).forEach(file -> itemFactory.create(item, child -> {
                        child.getProperties().set("source", file);
                        child.createContent(FileContent.class).withData((Object)file.toFile()).save();
                    }));
                }
                catch (Exception e) {
                    this.log().error("Unable to read files in folder {}", (Object)p, (Object)e);
                }
            });
            return SourceResponse.ok();
        }
    }
}

