/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.sources;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.SourceResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.data.ItemFactory;
import io.annot8.api.exceptions.Annot8RuntimeException;
import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractSource;
import io.annot8.common.components.AbstractSourceDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.FileContent;
import jakarta.json.bind.annotation.JsonbCreator;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ComponentName(value="File System Source")
@ComponentDescription(value="Provides items from the local file system")
@SettingsClass(value=Settings.class)
public class FileSystemSource
extends AbstractSourceDescriptor<Source, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withCreatesContent(FileContent.class).build();
    }

    protected Source createComponent(Context context, Settings settings) {
        return new Source(settings);
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private Path rootFolder = Paths.get(".", new String[0]);
        private boolean watching = true;
        private boolean recursive = true;
        private boolean reprocessOnModify = true;
        private Set<Pattern> acceptedFileNamePatterns = new HashSet<Pattern>();
        private boolean negateAcceptedFileNamePatterns = false;
        private long delay = 0L;

        @JsonbCreator
        public Settings() {
        }

        public Settings(Path rootFolder) {
            this.rootFolder = rootFolder;
        }

        @Description(value="Root folder to read from", defaultValue=".")
        public Path getRootFolder() {
            return this.rootFolder;
        }

        public void setRootFolder(Path rootFolder) {
            this.rootFolder = rootFolder;
        }

        @Description(value="Should the folder be read recursively", defaultValue="true")
        public boolean isRecursive() {
            return this.recursive;
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }

        @Description(value="Should files be reprocessed if they are modified", defaultValue="true")
        public boolean isReprocessOnModify() {
            return this.reprocessOnModify;
        }

        public void setReprocessOnModify(boolean reprocessOnModify) {
            this.reprocessOnModify = reprocessOnModify;
        }

        @Description(value="Accepted file name patterns")
        public Set<Pattern> getAcceptedFileNamePatterns() {
            return this.acceptedFileNamePatterns;
        }

        public void setAcceptedFileNamePatterns(Set<Pattern> acceptedFileNamePatterns) {
            this.acceptedFileNamePatterns = acceptedFileNamePatterns;
        }

        @Description(value="If true, then the list of accepted file name patterns is treated as a reject list rather than an accept list", defaultValue="false")
        public boolean isNegateAcceptedFileNamePatterns() {
            return this.negateAcceptedFileNamePatterns;
        }

        public void setNegateAcceptedFileNamePatterns(boolean negateAcceptedFileNamePatterns) {
            this.negateAcceptedFileNamePatterns = negateAcceptedFileNamePatterns;
        }

        @Description(value="Should the folder be watched for changes (true), or just scanned once (false)", defaultValue="true")
        public boolean isWatching() {
            return this.watching;
        }

        public void setWatching(boolean watching) {
            this.watching = watching;
        }

        @Description(value="The length of delay to introduce between the file being detected and the file being processed - can be used to avoid partially copied files being picked up", defaultValue="0")
        public long getDelay() {
            return this.delay;
        }

        public void setDelay(long delay) {
            this.delay = delay;
        }

        public boolean validate() {
            return this.rootFolder != null && this.acceptedFileNamePatterns != null && this.delay >= 0L;
        }
    }

    public static class Source
    extends AbstractSource {
        private final WatchService watchService;
        private final Settings settings;
        private final Set<Path> initialFiles = new HashSet<Path>();
        private final Set<Path> queue = Collections.synchronizedSet(new HashSet());

        public Source(final Settings settings) {
            this.settings = settings;
            if (settings.isWatching()) {
                try {
                    this.watchService = FileSystems.getDefault().newWatchService();
                }
                catch (IOException e) {
                    throw new Annot8RuntimeException("Unable to initialize WatchService", (Throwable)e);
                }
            } else {
                this.watchService = null;
            }
            try {
                Path p = settings.getRootFolder();
                if (settings.isRecursive()) {
                    Files.walkFileTree(p, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attr) throws IOException {
                            this.registerDirectory(dir);
                            return FileVisitResult.CONTINUE;
                        }

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                            if (Source.acceptFile(file, settings)) {
                                initialFiles.add(file);
                            }
                            return FileVisitResult.CONTINUE;
                        }
                    });
                } else {
                    this.registerDirectory(p);
                    Files.list(p).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> Source.acceptFile(file, settings)).forEach(this.initialFiles::add);
                }
            }
            catch (IOException ioe) {
                throw new BadConfigurationException("Unable to register folder or sub-folder with watch service or list initial files", (Throwable)ioe);
            }
            this.log().info("{} files identified for initial processing", (Object)this.initialFiles.size());
        }

        private void registerDirectory(Path path) throws IOException {
            if (this.settings.isWatching()) {
                if (this.settings.isReprocessOnModify()) {
                    this.log().info("Registering {} with watch service for CREATE and MODIFY events", (Object)path);
                    path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
                } else {
                    this.log().info("Registering {} with watch service for CREATE events", (Object)path);
                    path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE);
                }
            }
        }

        public static boolean acceptFile(Path file, Settings settings) {
            if (settings.getAcceptedFileNamePatterns().isEmpty()) {
                return true;
            }
            boolean matched = settings.getAcceptedFileNamePatterns().stream().map(p -> p.matcher(file.getFileName().toString())).anyMatch(Matcher::matches);
            return matched != settings.isNegateAcceptedFileNamePatterns();
        }

        public SourceResponse read(ItemFactory itemFactory) {
            WatchKey key;
            long read = 0L;
            if (!this.initialFiles.isEmpty()) {
                read += this.initialFiles.stream().filter(this.queue::add).peek(file -> this.createItem(itemFactory, (Path)file, this.settings.getDelay())).mapToLong(p -> 1L).sum();
                this.initialFiles.clear();
            }
            if (this.watchService == null || !this.settings.isWatching()) {
                return this.queue.isEmpty() ? SourceResponse.done() : SourceResponse.empty();
            }
            while ((key = this.watchService.poll()) != null) {
                Path dir = (Path)key.watchable();
                List<WatchEvent<?>> events = key.pollEvents();
                events.stream().filter(e -> e.kind() == StandardWatchEventKinds.ENTRY_CREATE).map(event -> dir.resolve((Path)event.context())).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(p -> {
                    try {
                        this.registerDirectory((Path)p);
                    }
                    catch (IOException e) {
                        this.log().error("Unable to watch new folder {}", p);
                    }
                });
                read += events.stream().map(event -> dir.resolve((Path)event.context())).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> Source.acceptFile(file, this.settings)).filter(this.queue::add).peek(file -> this.createItem(itemFactory, (Path)file, this.settings.getDelay())).mapToLong(p -> 1L).sum();
                key.reset();
            }
            return read > 0L ? SourceResponse.ok() : SourceResponse.empty();
        }

        private void createItem(final ItemFactory itemFactory, final Path path, long delay) {
            this.log().debug("Scheduling item creation for {} after delay of {} milliseconds", (Object)path, (Object)delay);
            new Timer().schedule(new TimerTask(){

                @Override
                public void run() {
                    this.log().debug("Creating item from {}", (Object)path);
                    itemFactory.create(i -> this.createFileContent((Item)i, path));
                    queue.remove(path);
                }
            }, delay);
        }

        private void createFileContent(Item item, Path path) {
            item.getProperties().set("source", (Object)path);
            item.getProperties().set("accessedAt", (Object)Instant.now().getEpochSecond());
            item.createContent(FileContent.class).withDescription("File " + path.toString()).withData((Object)path.toFile()).save();
        }
    }
}

