/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.sinks;

import de.siegmar.fastcsv.writer.CsvWriter;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.Table;
import io.annot8.common.data.content.TableContent;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;

@ComponentName(value="Table Content to CSV")
@ComponentDescription(value="Saves Table Content as a CSV file")
@SettingsClass(value=Settings.class)
public class TablesToCSV
extends AbstractProcessorDescriptor<Processor, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(TableContent.class).build();
    }

    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private Path outputFolder = Path.of("./csv", new String[0]);

        public boolean validate() {
            return this.outputFolder != null;
        }

        @Description(value="The folder to save CSV files in")
        public Path getOutputFolder() {
            return this.outputFolder;
        }

        public void setOutputFolder(Path outputFolder) {
            this.outputFolder = outputFolder;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final Settings settings;

        public Processor(Settings settings) {
            this.settings = settings;
        }

        public ProcessorResponse process(Item item) {
            ArrayList exceptions = new ArrayList();
            item.getContents(TableContent.class).forEach(t -> {
                Path p = this.settings.getOutputFolder().resolve(item.getId()).resolve(t.getId() + ".csv");
                try {
                    Files.createDirectories(p.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    this.log().error("Could not create directory {}", (Object)p.getParent());
                    exceptions.add(e);
                }
                try (CsvWriter writer = CsvWriter.builder().build(p, Charset.defaultCharset(), new OpenOption[0]);){
                    Table tbl = (Table)t.getData();
                    if (tbl.getColumnNames().isPresent()) {
                        writer.writeRow((Iterable)tbl.getColumnNames().get());
                    }
                    tbl.getRows().map(r -> {
                        ArrayList<String> s = new ArrayList<String>(r.getColumnCount());
                        for (int i = 0; i < r.getColumnCount(); ++i) {
                            s.add(r.getValueAt(i).orElse("").toString());
                        }
                        return s;
                    }).filter(l -> !l.stream().allMatch(String::isBlank)).forEach(arg_0 -> ((CsvWriter)writer).writeRow(arg_0));
                }
                catch (IOException ioe) {
                    this.log().error("Unable to write CSV file for {}", (Object)t.getId(), (Object)ioe);
                    exceptions.add(ioe);
                }
            });
            if (exceptions.isEmpty()) {
                return ProcessorResponse.ok();
            }
            return ProcessorResponse.itemError(exceptions);
        }
    }
}

