/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.FileContent;
import io.annot8.common.data.content.Text;
import io.annot8.components.files.processors.RemoveSourceContentSettings;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@ComponentName(value="Txt File Extractor")
@ComponentDescription(value="Extract text from a *.txt file and create Text content")
@SettingsClass(value=Settings.class)
public class TxtFileExtractor
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.isRemoveSourceContent(), settings.getExtensions(), settings.getCharset());
    }

    public Capabilities capabilities() {
        SimpleCapabilities.Builder builder = new SimpleCapabilities.Builder().withProcessesContent(FileContent.class).withCreatesContent(Text.class);
        if (((Settings)this.getSettings()).isRemoveSourceContent()) {
            builder = builder.withDeletesContent(FileContent.class);
        }
        return builder.build();
    }

    public static class Settings
    extends RemoveSourceContentSettings {
        private List<String> extensions = List.of("txt");
        private String charset = Charset.defaultCharset().name();

        @Description(value="The list of file extensions on which this processor will act (case insensitive). If empty, then the processor will act on all files.")
        public List<String> getExtensions() {
            return this.extensions;
        }

        public void setExtensions(List<String> extensions) {
            this.extensions = extensions.stream().map(String::toLowerCase).collect(Collectors.toList());
        }

        @Description(value="The charset to read the files with")
        public String getCharset() {
            return this.charset;
        }

        public void setCharset(String charset) {
            this.charset = charset;
        }

        @Override
        public boolean validate() {
            return super.validate() && this.extensions != null && Charset.isSupported(this.charset);
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final boolean removeSourceContent;
        private final List<String> extensions;
        private final Charset charset;

        public Processor(boolean removeSourceContent, List<String> extensions, String charset) {
            this.removeSourceContent = removeSourceContent;
            this.extensions = extensions;
            if (Charset.isSupported(charset)) {
                this.charset = Charset.forName(charset);
            } else {
                this.log().error("Charset {} is not supported - default charset {} will be used instead", (Object)charset, (Object)Charset.defaultCharset().name());
                this.charset = Charset.defaultCharset();
            }
        }

        public ProcessorResponse process(Item item) {
            item.getContents(FileContent.class).filter(f -> this.extensions.isEmpty() || this.extensions.contains(this.getExtension(((File)f.getData()).getName()).orElse(""))).forEach(f -> {
                try {
                    File file = (File)f.getData();
                    String data = Files.readString(file.toPath(), this.charset);
                    item.createContent(Text.class).withDescription("Text from " + f.getId()).withData((Object)data).save();
                    if (this.removeSourceContent) {
                        item.removeContent((Content)f);
                    }
                }
                catch (Exception e) {
                    this.log().warn("Unable to process file {}", (Object)((File)f.getData()).getAbsolutePath(), (Object)e);
                }
            });
            return ProcessorResponse.ok();
        }

        private Optional<String> getExtension(String filename) {
            return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1).toLowerCase());
        }
    }
}

