/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.FileContent;

@ComponentName(value="Discard Unextracted Files")
@ComponentDescription(value="Discards FileContent which hasn't been extracted into other Content")
public class DiscardUnextractedFiles
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(FileContent.class).withDeletesContent(FileContent.class).build();
    }

    public static class Processor
    extends AbstractProcessor {
        public ProcessorResponse process(Item item) {
            boolean noOtherContent;
            item.getContents(FileContent.class).forEach(arg_0 -> ((Item)item).removeContent(arg_0));
            boolean bl = noOtherContent = item.getContents().count() == 0L;
            if (noOtherContent) {
                item.discard();
            }
            return ProcessorResponse.ok();
        }
    }
}

