/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.sources;

import io.annot8.components.files.sources.AbstractFileSystemSource;
import io.annot8.components.files.sources.FileSystemSourceSettings;
import io.annot8.core.components.responses.SourceResponse;
import io.annot8.core.context.Context;
import io.annot8.core.data.ItemFactory;
import io.annot8.core.exceptions.Annot8RuntimeException;
import io.annot8.core.exceptions.BadConfigurationException;
import io.annot8.core.exceptions.MissingResourceException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileSystemSource
extends AbstractFileSystemSource {
    private final WatchService watchService;
    private final Set<WatchKey> watchKeys = new HashSet<WatchKey>();
    private final Set<Path> initialFiles = new HashSet<Path>();

    public FileSystemSource() {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            throw new Annot8RuntimeException("Unable to initialize WatchService", (Throwable)e);
        }
    }

    @Override
    public void configure(Context context) throws BadConfigurationException, MissingResourceException {
        super.configure(context);
        this.watchKeys.forEach(WatchKey::cancel);
        this.watchKeys.clear();
        this.initialFiles.clear();
        try {
            Path p = this.getSettings().getRootFolder();
            if (this.getSettings().isRecursive()) {
                Files.walkFileTree(p, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attr) throws IOException {
                        FileSystemSource.this.registerDirectory(FileSystemSource.this.getSettings(), dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else {
                this.registerDirectory(this.getSettings(), p);
            }
            this.addFilesFromDir(this.getSettings(), p.toFile());
        }
        catch (IOException ioe) {
            throw new BadConfigurationException("Unable to register folder or sub-folder with watch service", (Throwable)ioe);
        }
    }

    private void registerDirectory(FileSystemSourceSettings settings, Path path) throws IOException {
        WatchKey key = settings.isReprocessOnModify() ? path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY) : path.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE);
        this.watchKeys.add(key);
    }

    private void addFilesFromDir(FileSystemSourceSettings settings, File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        block0: for (File file : files) {
            if (!file.isDirectory()) {
                Path path = file.toPath();
                if (this.getAcceptedFilePatterns().isEmpty()) {
                    this.initialFiles.add(path);
                    continue;
                }
                for (Pattern p : this.getAcceptedFilePatterns()) {
                    Matcher m = p.matcher(path.getFileName().toString());
                    if (!m.matches()) continue;
                    this.initialFiles.add(path);
                    continue block0;
                }
                continue;
            }
            if (!settings.isRecursive()) continue;
            this.addFilesFromDir(settings, file);
        }
    }

    public SourceResponse read(ItemFactory itemFactory) {
        WatchKey key;
        if (!this.initialFiles.isEmpty()) {
            this.initialFiles.forEach(path -> this.createItem(itemFactory, (Path)path));
            this.initialFiles.clear();
            if (!this.getSettings().isWatching()) {
                this.watchKeys.forEach(WatchKey::cancel);
                this.watchKeys.clear();
                return SourceResponse.done();
            }
        }
        boolean read = false;
        while ((key = this.watchService.poll()) != null) {
            for (WatchEvent<?> event : key.pollEvents()) {
                if (!this.createItem(itemFactory, (Path)event.context())) continue;
                read = true;
            }
            key.reset();
        }
        if (read) {
            return SourceResponse.ok();
        }
        return SourceResponse.empty();
    }
}

