/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.processors;

import io.annot8.common.data.bounds.NoBounds;
import io.annot8.common.data.content.FileContent;
import io.annot8.components.base.components.AbstractComponent;
import io.annot8.core.annotations.Annotation;
import io.annot8.core.bounds.Bounds;
import io.annot8.core.capabilities.ProcessesContent;
import io.annot8.core.components.Processor;
import io.annot8.core.components.responses.ProcessorResponse;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.stores.AnnotationStore;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;

@ProcessesContent(value=FileContent.class)
public class FileMetadataExtractor
extends AbstractComponent
implements Processor {
    public static final String FILE_METADATA = "FILE_METADATA";

    public ProcessorResponse process(Item item) {
        boolean withoutErrors = item.getContents(FileContent.class).map(this::extractMetadata).reduce(true, (a, b) -> a != false && b != false);
        if (!withoutErrors) {
            return ProcessorResponse.itemError();
        }
        return ProcessorResponse.ok();
    }

    private boolean extractMetadata(FileContent fileContent) {
        BasicFileAttributes attr;
        String owner;
        boolean isSym;
        boolean isDir;
        boolean isRegular;
        boolean isHidden;
        File file = (File)fileContent.getData();
        if (!file.exists()) {
            return false;
        }
        try {
            isHidden = Files.isHidden(file.toPath());
            isRegular = Files.isRegularFile(file.toPath(), new LinkOption[0]);
            isDir = Files.isDirectory(file.toPath(), new LinkOption[0]);
            isSym = Files.isSymbolicLink(file.toPath());
            owner = Files.getOwner(file.toPath(), new LinkOption[0]).getName();
        }
        catch (IOException e) {
            this.log().error("Failed to retrieve file metadata", (Throwable)e);
            return false;
        }
        try {
            attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            this.log().error("Failed to process file attributes", (Throwable)e);
            return false;
        }
        if (attr != null) {
            this.createMetadataAnnotation(fileContent, "DATE_CREATED", attr.creationTime().toMillis());
            this.createMetadataAnnotation(fileContent, "LAST_MODIFIED", attr.lastModifiedTime().toMillis());
            this.createMetadataAnnotation(fileContent, "LAST_ACCESS_DATE", attr.lastAccessTime().toMillis());
            this.createMetadataAnnotation(fileContent, "FILE_SIZE", attr.size());
        }
        this.createMetadataAnnotation(fileContent, "PATH", file.getAbsolutePath());
        this.createMetadataAnnotation(fileContent, "HIDDEN", isHidden);
        this.createMetadataAnnotation(fileContent, "REGULAR", isRegular);
        this.createMetadataAnnotation(fileContent, "DIRECTORY", isDir);
        this.createMetadataAnnotation(fileContent, "SYM_LINK", isSym);
        this.createMetadataAnnotation(fileContent, "OWNER", owner);
        String extension = this.getFileExtension(file);
        if (extension != null) {
            this.createMetadataAnnotation(fileContent, "EXTENSION", extension);
        }
        return true;
    }

    private String getFileExtension(File file) {
        int index = file.getAbsolutePath().lastIndexOf(46);
        if (index > 0 && index != file.getAbsolutePath().length()) {
            return file.getAbsolutePath().substring(index + 1);
        }
        return null;
    }

    private void createMetadataAnnotation(FileContent content, String key, Object value) {
        AnnotationStore annotations = content.getAnnotations();
        try {
            ((Annotation.Builder)((Annotation.Builder)annotations.create().withType(FILE_METADATA)).withBounds((Bounds)NoBounds.getInstance()).withProperty(key, value)).save();
        }
        catch (IncompleteException e) {
            this.log().error("Failed to create file metadata annotation", (Throwable)e);
        }
    }
}

