/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.db.utils;

import io.annot8.api.exceptions.Annot8RuntimeException;
import io.annot8.common.data.content.ColumnMetadata;
import io.annot8.common.data.content.DefaultRow;
import io.annot8.common.data.content.Row;
import io.annot8.common.data.content.TableMetadata;
import io.annot8.components.db.processors.JdbcSettings;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;

public class DatabaseTableIterator
implements Iterator<Row> {
    private ResultSet resultSet;
    private TableMetadata metadata;
    private JdbcSettings settings;
    private List<String> columnNames;

    public DatabaseTableIterator(ResultSet set, TableMetadata metadata) {
        this.resultSet = set;
        this.metadata = metadata;
        this.columnNames = this.metadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toList());
    }

    @Override
    public boolean hasNext() {
        if (this.resultSet == null) {
            return false;
        }
        try {
            if (this.resultSet.isClosed()) {
                return false;
            }
            return this.resultSet.getRow() != this.metadata.getRowCount();
        }
        catch (SQLException e) {
            throw new Annot8RuntimeException("Failed to fetch row count", (Throwable)e);
        }
    }

    @Override
    public Row next() {
        try {
            if (this.resultSet.isClosed()) {
                throw new NoSuchElementException("Result set is closed");
            }
            this.resultSet.next();
            Row row = this.resultSetToRow(this.resultSet);
            return row;
        }
        catch (SQLException e) {
            throw new Annot8RuntimeException("Failed to iterate results", (Throwable)e);
        }
    }

    private Row resultSetToRow(ResultSet resultSet) throws SQLException {
        int index = resultSet.getRow() - 1;
        ArrayList<Object> data = new ArrayList<Object>();
        for (int i = 1; i < this.metadata.getColumns().size() + 1; ++i) {
            data.add(resultSet.getObject(i));
        }
        return new DefaultRow(index, this.columnNames, data);
    }
}

