/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.failureanalyzer;

import io.allune.quickfixj.spring.boot.starter.exception.ConfigurationException;
import io.allune.quickfixj.spring.boot.starter.exception.QuickFixJBaseException;
import io.allune.quickfixj.spring.boot.starter.exception.SettingsNotFoundException;
import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;

public class QuickFixJAutoConfigFailureAnalyzer
extends AbstractFailureAnalyzer<QuickFixJBaseException> {
    protected FailureAnalysis analyze(Throwable rootFailure, QuickFixJBaseException cause) {
        Object descriptionMessage = cause.getMessage();
        String actionMessage = cause.getMessage();
        String rootCauseMessage = this.getRootCauseMessage(cause);
        if (cause instanceof ConfigurationException) {
            descriptionMessage = "A configuration error has been detected in the QuickFIX/J settings provided: " + rootCauseMessage;
            actionMessage = "Please configure your QuickFIX/J settings as per the documentation: https://www.quickfixj.org/usermanual/2.1.0/usage/configuration.html";
        }
        if (cause instanceof SettingsNotFoundException) {
            descriptionMessage = "The QuickFIX/J settings file could not be found: " + rootCauseMessage;
            actionMessage = "Please provide a QuickFIX/J settings file on the property 'config' for the client/server section in your configuration file.";
        }
        return new FailureAnalysis((String)descriptionMessage, actionMessage, (Throwable)((Object)cause));
    }

    private String getRootCauseMessage(QuickFixJBaseException cause) {
        String rootCauseMessage = "no root cause found";
        Throwable rootCause = QuickFixJAutoConfigFailureAnalyzer.getRootCause((Throwable)((Object)cause));
        if (rootCause != null) {
            rootCauseMessage = rootCause.getMessage() != null ? rootCause.getMessage() : "";
        }
        return rootCauseMessage;
    }

    public static Throwable getRootCause(Throwable throwable) {
        Throwable rootCause;
        for (rootCause = throwable; rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
        }
        return rootCause;
    }
}

