/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.template;

import io.allune.quickfixj.spring.boot.starter.exception.FieldNotFoundException;
import io.allune.quickfixj.spring.boot.starter.exception.MessageValidationException;
import io.allune.quickfixj.spring.boot.starter.exception.SessionNotFoundException;
import io.allune.quickfixj.spring.boot.starter.template.DefaultSessionLookupHandler;
import io.allune.quickfixj.spring.boot.starter.template.QuickFixJOperations;
import io.allune.quickfixj.spring.boot.starter.template.SessionLookupHandler;
import lombok.NonNull;
import org.springframework.util.Assert;
import quickfix.DataDictionary;
import quickfix.DataDictionaryProvider;
import quickfix.FieldNotFound;
import quickfix.LogUtil;
import quickfix.Message;
import quickfix.MessageUtils;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.field.ApplVerID;

public class QuickFixJTemplate
implements QuickFixJOperations {
    private SessionLookupHandler sessionLookupHandler;
    private boolean doValidation;

    public QuickFixJTemplate() {
        this.sessionLookupHandler = new DefaultSessionLookupHandler();
        this.doValidation = true;
    }

    public QuickFixJTemplate(SessionLookupHandler sessionLookupHandler) {
        this.sessionLookupHandler = sessionLookupHandler;
        this.doValidation = true;
    }

    public void setSessionLookupHandler(SessionLookupHandler sessionLookupHandler) {
        this.sessionLookupHandler = sessionLookupHandler;
    }

    public void setDoValidation(boolean doValidation) {
        this.doValidation = doValidation;
    }

    @Override
    public boolean send(Message message) {
        Assert.notNull((Object)message, (String)"'message' must not be null");
        SessionID sessionID = QuickFixJSessionID.quickFixJSessionIDBuilder().message(message).build().toSessionID();
        return this.doSend(message, sessionID);
    }

    @Override
    public boolean send(Message message, String qualifier) {
        Assert.notNull((Object)message, (String)"'message' must not be null");
        SessionID sessionID = QuickFixJSessionID.quickFixJSessionIDBuilder().message(message).qualifier(qualifier).build().toSessionID();
        return this.doSend(message, sessionID);
    }

    @Override
    public boolean send(Message message, String senderCompID, String targetCompID) {
        Assert.notNull((Object)message, (String)"'message' must not be null");
        SessionID sessionID = QuickFixJSessionID.quickFixJSessionIDBuilder().message(message).senderCompID(senderCompID).targetCompID(targetCompID).build().toSessionID();
        return this.doSend(message, sessionID);
    }

    @Override
    public boolean send(Message message, String senderCompID, String targetCompID, String qualifier) {
        Assert.notNull((Object)message, (String)"'message' must not be null");
        SessionID sessionID = QuickFixJSessionID.quickFixJSessionIDBuilder().message(message).senderCompID(senderCompID).targetCompID(targetCompID).qualifier(qualifier).build().toSessionID();
        return this.doSend(message, sessionID);
    }

    @Override
    public boolean send(Message message, SessionID sessionID) {
        Assert.notNull((Object)message, (String)"'message' must not be null");
        Assert.notNull((Object)sessionID, (String)"'sessionID' must not be null");
        return this.doSend(message, sessionID);
    }

    protected boolean doSend(Message message, SessionID sessionID) {
        Session session = this.sessionLookupHandler.lookupBySessionID(sessionID);
        if (session == null) {
            throw new SessionNotFoundException("Session not found: " + sessionID.toString());
        }
        if (this.doValidation) {
            this.validateMessage(message, sessionID, session);
        }
        return session.send(message);
    }

    private void validateMessage(Message message, SessionID sessionID, Session session) {
        DataDictionaryProvider dataDictionaryProvider = session.getDataDictionaryProvider();
        if (dataDictionaryProvider != null) {
            try {
                ApplVerID applVerID = QuickFixJTemplate.getApplicationVersionID(message, session);
                DataDictionary applicationDataDictionary = dataDictionaryProvider.getApplicationDataDictionary(applVerID);
                applicationDataDictionary.validate(message, true);
            }
            catch (Exception e) {
                LogUtil.logThrowable((SessionID)sessionID, (String)("Message failed validation: " + e.getMessage()), (Throwable)e);
                throw new MessageValidationException("Message failed validation: " + e.getMessage(), e);
            }
        }
    }

    private static ApplVerID getApplicationVersionID(Message message, Session session) {
        if (message.getHeader() == null) {
            return QuickFixJTemplate.getDefaultApplVerID(session);
        }
        try {
            String applVerId = message.getHeader().getString(1128);
            return new ApplVerID(applVerId);
        }
        catch (FieldNotFound fieldNotFound) {
            return QuickFixJTemplate.getDefaultApplVerID(session);
        }
    }

    private static ApplVerID getDefaultApplVerID(Session session) {
        String beginString = session.getSessionID().getBeginString();
        if ("FIXT.1.1".equals(beginString)) {
            return session.getSenderDefaultApplicationVersionID();
        }
        return MessageUtils.toApplVerID((String)beginString);
    }

    static class QuickFixJSessionID {
        @NonNull
        public Message message;
        public String beginString;
        public String senderCompID;
        public String targetCompID;
        public String qualifier;

        public SessionID toSessionID() {
            if (this.beginString == null) {
                this.beginString = QuickFixJSessionID.getFieldFromMessageHeader(this.message, 8);
            }
            if (this.senderCompID == null) {
                this.senderCompID = QuickFixJSessionID.getFieldFromMessageHeader(this.message, 49);
            }
            if (this.targetCompID == null) {
                this.targetCompID = QuickFixJSessionID.getFieldFromMessageHeader(this.message, 56);
            }
            if (this.qualifier == null) {
                this.qualifier = "";
            }
            return new SessionID(this.beginString, this.senderCompID, this.targetCompID, this.qualifier);
        }

        private static String getFieldFromMessageHeader(Message message, int fieldTag) {
            try {
                return message.getHeader().getString(fieldTag);
            }
            catch (FieldNotFound fieldNotFound) {
                throw new FieldNotFoundException("Field with ID " + fieldTag + " not found in message", fieldNotFound);
            }
        }

        QuickFixJSessionID(@NonNull Message message, String beginString, String senderCompID, String targetCompID, String qualifier) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            this.beginString = beginString;
            this.senderCompID = senderCompID;
            this.targetCompID = targetCompID;
            this.qualifier = qualifier;
        }

        public static QuickFixJSessionIDBuilder quickFixJSessionIDBuilder() {
            return new QuickFixJSessionIDBuilder();
        }

        public static class QuickFixJSessionIDBuilder {
            private Message message;
            private String beginString;
            private String senderCompID;
            private String targetCompID;
            private String qualifier;

            QuickFixJSessionIDBuilder() {
            }

            public QuickFixJSessionIDBuilder message(@NonNull Message message) {
                if (message == null) {
                    throw new NullPointerException("message is marked non-null but is null");
                }
                this.message = message;
                return this;
            }

            public QuickFixJSessionIDBuilder beginString(String beginString) {
                this.beginString = beginString;
                return this;
            }

            public QuickFixJSessionIDBuilder senderCompID(String senderCompID) {
                this.senderCompID = senderCompID;
                return this;
            }

            public QuickFixJSessionIDBuilder targetCompID(String targetCompID) {
                this.targetCompID = targetCompID;
                return this;
            }

            public QuickFixJSessionIDBuilder qualifier(String qualifier) {
                this.qualifier = qualifier;
                return this;
            }

            public QuickFixJSessionID build() {
                return new QuickFixJSessionID(this.message, this.beginString, this.senderCompID, this.targetCompID, this.qualifier);
            }

            public String toString() {
                return "QuickFixJTemplate.QuickFixJSessionID.QuickFixJSessionIDBuilder(message=" + this.message + ", beginString=" + this.beginString + ", senderCompID=" + this.senderCompID + ", targetCompID=" + this.targetCompID + ", qualifier=" + this.qualifier + ")";
            }
        }
    }
}

