/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.actuate.health;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import quickfix.Connector;
import quickfix.Session;
import quickfix.SessionID;
import quickfix.SessionSchedule;
import quickfix.SessionScheduleFactory;
import quickfix.SessionSettings;

public class QuickFixJSessionHealthIndicator
extends AbstractHealthIndicator {
    private final Connector connector;
    private final SessionScheduleFactory sessionScheduleFactory;
    private final SessionSettings sessionSettings;
    private final Map<SessionID, SessionSchedule> sessionScheduleMap = new ConcurrentHashMap<SessionID, SessionSchedule>();

    public QuickFixJSessionHealthIndicator(Connector connector, SessionScheduleFactory sessionScheduleFactory, SessionSettings sessionSettings) {
        this.connector = connector;
        this.sessionScheduleFactory = sessionScheduleFactory;
        this.sessionSettings = sessionSettings;
    }

    protected void doHealthCheck(Health.Builder builder) {
        this.connector.getSessions().forEach(sessionID -> {
            SessionSchedule sessionSchedule = this.sessionScheduleMap.computeIfAbsent((SessionID)sessionID, id -> this.getSessionSchedule((SessionID)sessionID).orElse(null));
            SessionStatus sessionStatus = this.getSessionStatus((SessionID)sessionID, sessionSchedule);
            switch (sessionStatus) {
                case LOGGED_ON: {
                    builder.up().withDetail(sessionID.toString(), (Object)"LoggedOn");
                    break;
                }
                case LOGGED_OFF: {
                    builder.down().withDetail(sessionID.toString(), (Object)"LoggedOff");
                    break;
                }
                case NOT_IN_SESSION: {
                    builder.unknown().withDetail(sessionID.toString(), (Object)"NotInSession");
                    break;
                }
                default: {
                    builder.outOfService().withDetail(sessionID.toString(), (Object)"Error");
                }
            }
            if (sessionSchedule != null) {
                builder.withDetail("sessionSchedule", (Object)sessionSchedule.toString());
            }
        });
    }

    private Optional<SessionSchedule> getSessionSchedule(SessionID sessionID) {
        try {
            return Optional.of(this.sessionScheduleFactory.create(sessionID, this.sessionSettings));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private SessionStatus getSessionStatus(SessionID sessionID, SessionSchedule sessionSchedule) {
        if (sessionID == null || sessionSchedule == null) {
            return SessionStatus.ERROR;
        }
        try {
            if (sessionSchedule.isSessionTime()) {
                Session session = Session.lookupSession((SessionID)sessionID);
                if (session != null && session.isLoggedOn()) {
                    return SessionStatus.LOGGED_ON;
                }
                return SessionStatus.LOGGED_OFF;
            }
            return SessionStatus.NOT_IN_SESSION;
        }
        catch (Exception e) {
            return SessionStatus.ERROR;
        }
    }

    public static enum SessionStatus {
        LOGGED_ON("LoggedOn"),
        LOGGED_OFF("LoggedOff"),
        NOT_IN_SESSION("NotInSession"),
        ERROR("Error");

        private final String description;

        private SessionStatus(String description) {
            this.description = description;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }
    }
}

