/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.actuate.endpoint;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import quickfix.ConfigError;
import quickfix.Connector;
import quickfix.SessionID;
import quickfix.SessionSettings;

public class AbstractQuickFixJEndpoint {
    private final Connector connector;
    private final SessionSettings sessionSettings;

    AbstractQuickFixJEndpoint(Connector connector, SessionSettings sessionSettings) {
        this.connector = connector;
        this.sessionSettings = sessionSettings;
    }

    @ReadOperation
    public Map<String, Properties> readProperties() {
        HashMap<String, Properties> reports = new HashMap<String, Properties>();
        this.connector.getSessions().forEach(sessionId -> {
            try {
                Properties p = new Properties();
                p.putAll((Map<?, ?>)this.sessionSettings.getDefaultProperties());
                p.putAll((Map<?, ?>)this.sessionSettings.getSessionProperties(sessionId));
                p.putAll((Map<?, ?>)this.addSessionIdProperties((SessionID)sessionId));
                reports.put(sessionId.toString(), p);
            }
            catch (ConfigError e) {
                throw new IllegalStateException(e);
            }
        });
        return reports;
    }

    private Properties addSessionIdProperties(SessionID sessionID) {
        String sessionQualifier;
        String targetLocationID;
        String senderLocationID;
        Properties properties = new Properties();
        properties.put("BeginString", sessionID.getBeginString());
        properties.put("SenderCompID", sessionID.getSenderCompID());
        String senderSubID = sessionID.getSenderSubID();
        if (!senderSubID.equals("")) {
            properties.put("SenderSubID", senderSubID);
        }
        if (!(senderLocationID = sessionID.getSenderLocationID()).equals("")) {
            properties.put("SenderLocationID", senderLocationID);
        }
        properties.put("TargetCompID", sessionID.getTargetCompID());
        String targetSubID = sessionID.getTargetSubID();
        if (!targetSubID.equals("")) {
            properties.put("TargetSubID", targetSubID);
        }
        if (!(targetLocationID = sessionID.getTargetLocationID()).equals("")) {
            properties.put("TargetLocationID", targetLocationID);
        }
        if (!(sessionQualifier = sessionID.getSessionQualifier()).equals("")) {
            properties.put("Qualifier", sessionQualifier);
        }
        return properties;
    }
}

