/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.actuate.config;

import io.allune.quickfixj.spring.boot.actuate.endpoint.QuickFixJServerEndpoint;
import io.allune.quickfixj.spring.boot.actuate.health.QuickFixJSessionHealthIndicator;
import io.allune.quickfixj.spring.boot.starter.autoconfigure.server.QuickFixJServerAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import quickfix.Acceptor;
import quickfix.Connector;
import quickfix.DefaultSessionScheduleFactory;
import quickfix.SessionScheduleFactory;
import quickfix.SessionSettings;

@Configuration
@AutoConfigureAfter(value={QuickFixJServerAutoConfiguration.class})
public class QuickFixJServerEndpointAutoConfiguration {
    @Bean
    @ConditionalOnBean(name={"serverAcceptor", "serverSessionSettings"})
    @ConditionalOnClass(value={Acceptor.class, SessionSettings.class})
    @ConditionalOnMissingBean
    @ConditionalOnAvailableEndpoint
    public QuickFixJServerEndpoint quickfixjServerEndpoint(Acceptor serverAcceptor, SessionSettings serverSessionSettings) {
        return new QuickFixJServerEndpoint(serverAcceptor, serverSessionSettings);
    }

    @Bean
    @ConditionalOnBean(name={"serverAcceptor", "serverSessionSettings"})
    @ConditionalOnClass(value={Acceptor.class, SessionSettings.class})
    @ConditionalOnMissingBean
    public QuickFixJSessionHealthIndicator quickfixjServerSessionHealthIndicator(Acceptor serverAcceptor, SessionScheduleFactory sessionSchedule, SessionSettings clientSessionSettings) {
        return new QuickFixJSessionHealthIndicator((Connector)serverAcceptor, sessionSchedule, clientSessionSettings);
    }

    @Bean
    @ConditionalOnMissingBean
    public SessionScheduleFactory sessionSchedule() {
        return new DefaultSessionScheduleFactory();
    }
}

