/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.worker;

import io.aleph0.yap.core.worker.ConsumerWorkerFactory;
import io.aleph0.yap.core.worker.MeasuredConsumerWorker;
import java.util.Objects;

public class SingletonConsumerWorkerFactory<InputT, MetricsT>
implements ConsumerWorkerFactory<InputT, MetricsT> {
    private final MeasuredConsumerWorker<InputT, MetricsT> worker;
    private boolean created = false;

    public SingletonConsumerWorkerFactory(MeasuredConsumerWorker<InputT, MetricsT> worker) {
        this.worker = Objects.requireNonNull(worker);
    }

    @Override
    public MeasuredConsumerWorker<InputT, MetricsT> newConsumerWorker() {
        if (this.created) {
            throw new IllegalStateException("worker already created");
        }
        this.created = true;
        return this.worker;
    }

    @Override
    public MetricsT checkMetrics() {
        return (MetricsT)this.worker.checkMetrics();
    }

    @Override
    public MetricsT flushMetrics() {
        return (MetricsT)this.worker.flushMetrics();
    }
}

