/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.transport.topic;

import io.aleph0.yap.core.build.TopicBuilder;
import io.aleph0.yap.core.transport.Channel;
import io.aleph0.yap.core.transport.Topic;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class DefaultTopic<T>
implements Topic<T> {
    private final AtomicLong sent = new AtomicLong(0L);
    private final AtomicLong stalls = new AtomicLong(0L);
    private final List<Channel<T>> subscribers;
    private volatile boolean closed;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public DefaultTopic(List<Channel<T>> subscribers) {
        if (subscribers == null) {
            throw new NullPointerException();
        }
        if (subscribers.isEmpty()) {
            throw new IllegalArgumentException("subscribers must not be empty");
        }
        this.subscribers = Collections.unmodifiableList(subscribers);
    }

    @Override
    public void publish(T message) throws InterruptedException {
        if (this.closed) {
            throw new IllegalStateException("closed");
        }
        for (Channel<T> subscriber : this.subscribers) {
            boolean published = subscriber.tryPublish(message);
            if (!published) {
                this.stalls.incrementAndGet();
                subscriber.publish(message);
            }
            this.sent.incrementAndGet();
        }
    }

    @Override
    public void close() {
        this.closed = true;
        for (Channel<T> subscriber : this.subscribers) {
            subscriber.close();
        }
    }

    @Override
    public Topic.Metrics checkMetrics() {
        return new Topic.Metrics(this.sent.get(), this.stalls.get());
    }

    @Override
    public Topic.Metrics flushMetrics() {
        Topic.Metrics result = this.checkMetrics();
        this.sent.set(0L);
        this.stalls.set(0L);
        return result;
    }

    public static class Builder<T>
    implements TopicBuilder<T> {
        @Override
        public Topic<T> build(List<Channel<T>> channels) {
            return new DefaultTopic<T>(channels);
        }
    }
}

