/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.worker;

import io.aleph0.yap.core.ProcessorWorker;
import io.aleph0.yap.core.Sink;
import io.aleph0.yap.core.Source;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;

public class FlatMapProcessorWorker<X, Y>
implements ProcessorWorker<X, Y> {
    private final Function<X, Collection<Y>> function;

    public FlatMapProcessorWorker(Function<X, Collection<Y>> function) {
        this.function = Objects.requireNonNull(function, "function");
    }

    @Override
    public void process(Source<X> source, Sink<Y> sink) throws InterruptedException {
        X originalItem = source.take();
        while (originalItem != null) {
            Collection<Y> mappedItems = this.function.apply(originalItem);
            for (Y mappedItem : mappedItems) {
                sink.put(mappedItem);
            }
            originalItem = source.take();
        }
    }
}

