/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.worker;

import io.aleph0.yap.core.Sink;
import io.aleph0.yap.core.worker.MeasuredProducerWorker;
import io.aleph0.yap.core.worker.ProducerWorkerFactory;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;

public class DefaultProducerWorkerFactory<OutputT, MetricsT>
implements ProducerWorkerFactory<OutputT, MetricsT> {
    private final List<MeasuredProducerWorker<OutputT, MetricsT>> workers = new CopyOnWriteArrayList<MeasuredProducerWorker<OutputT, MetricsT>>();
    private final Supplier<MeasuredProducerWorker<OutputT, MetricsT>> workerSupplier;
    private final BinaryOperator<MetricsT> metricsAggregator;

    public DefaultProducerWorkerFactory(Supplier<MeasuredProducerWorker<OutputT, MetricsT>> workerSupplier, BinaryOperator<MetricsT> metricsAggregator) {
        this.workerSupplier = Objects.requireNonNull(workerSupplier, "workerSupplier");
        this.metricsAggregator = Objects.requireNonNull(metricsAggregator, "metricsAggregator");
    }

    @Override
    public MeasuredProducerWorker<OutputT, MetricsT> newProducerWorker() {
        final MeasuredProducerWorker<OutputT, MetricsT> newWorker = this.workerSupplier.get();
        return new MeasuredProducerWorker<OutputT, MetricsT>(){
            final /* synthetic */ DefaultProducerWorkerFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void produce(Sink<OutputT> sink) throws Exception {
                this.this$0.workers.add(this);
                try {
                    newWorker.produce(sink);
                }
                finally {
                    this.this$0.workers.remove(this);
                }
            }

            @Override
            public MetricsT checkMetrics() {
                return newWorker.checkMetrics();
            }

            @Override
            public MetricsT flushMetrics() {
                return newWorker.flushMetrics();
            }
        };
    }

    @Override
    public MetricsT checkMetrics() {
        Object result = null;
        for (MeasuredProducerWorker<OutputT, MetricsT> worker : this.workers) {
            Object metrics = worker.checkMetrics();
            if (result == null) {
                result = metrics;
                continue;
            }
            result = this.metricsAggregator.apply(result, metrics);
        }
        return (MetricsT)result;
    }

    @Override
    public MetricsT flushMetrics() {
        Object result = null;
        for (MeasuredProducerWorker<OutputT, MetricsT> worker : this.workers) {
            Object metrics = worker.flushMetrics();
            if (result == null) {
                result = metrics;
                continue;
            }
            result = this.metricsAggregator.apply(result, metrics);
        }
        return (MetricsT)result;
    }
}

