/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.task;

import io.aleph0.yap.core.task.action.TaskAction;
import io.aleph0.yap.core.transport.Queue;
import io.aleph0.yap.core.transport.Topic;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutionException;

public interface TaskController {
    public List<TaskAction> onTaskStart();

    public List<TaskAction> onWorkerStarted(int var1);

    public List<TaskAction> onWorkerStopped(int var1);

    public List<TaskAction> onWorkerCompletedNormally(int var1);

    public List<TaskAction> onWorkerCompletedExceptionally(int var1, Throwable var2);

    public List<TaskAction> onCancelRequested();

    public List<TaskAction> onHeartbeat();

    public Duration getHeartbeatInterval();

    public void onTaskSucceeded();

    public void onTaskCancelled();

    public void onTaskFailed(ExecutionException var1);

    public static interface ConsumerTaskControllerBuilder<InputT> {
        public TaskController build(Queue<InputT> var1);
    }

    public static interface ProcessorTaskControllerBuilder<InputT, OutputT> {
        public TaskController build(Queue<InputT> var1, Topic<OutputT> var2);
    }

    public static interface ProducerTaskControllerBuilder<OutputT> {
        public TaskController build(Topic<OutputT> var1);
    }
}

