/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.task;

import io.aleph0.yap.core.task.DefaultTaskController;
import io.aleph0.yap.core.task.TaskController;
import io.aleph0.yap.core.transport.Topic;
import java.time.Duration;

public class DefaultProducerTaskController<OutputT>
extends DefaultTaskController<Void, OutputT> {
    public static <OutputT> Builder<OutputT> builder() {
        return new Builder();
    }

    public DefaultProducerTaskController(int parallelism, Duration heartbeatInterval, Topic<OutputT> topic) {
        super(parallelism, heartbeatInterval, null, topic);
    }

    public static class Builder<OutputT>
    implements TaskController.ProducerTaskControllerBuilder<OutputT> {
        private int desiredConcurrency = 1;
        private Duration heartbeatInterval = Duration.ofSeconds(60L);

        public Builder<OutputT> setDesiredConcurrency(int parallelism) {
            if (parallelism < 1) {
                throw new IllegalArgumentException("desiredConcurrency must be at least 1");
            }
            this.desiredConcurrency = parallelism;
            return this;
        }

        public Builder<OutputT> setHeartbeatInterval(Duration heartbeatInterval) {
            if (heartbeatInterval == null) {
                throw new NullPointerException();
            }
            if (!heartbeatInterval.isPositive()) {
                throw new IllegalArgumentException("heartbeatInterval must be positive");
            }
            this.heartbeatInterval = heartbeatInterval;
            return this;
        }

        @Override
        public DefaultProducerTaskController<OutputT> build(Topic<OutputT> topic) {
            return new DefaultProducerTaskController<OutputT>(this.desiredConcurrency, this.heartbeatInterval, topic);
        }
    }
}

