/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.task;

import io.aleph0.yap.core.task.DefaultTaskController;
import io.aleph0.yap.core.task.TaskController;
import io.aleph0.yap.core.transport.Queue;
import io.aleph0.yap.core.transport.Topic;
import java.time.Duration;

public final class DefaultProcessorTaskController<InputT, OutputT>
extends DefaultTaskController<InputT, OutputT> {
    public static <InputT, OutputT> Builder<InputT, OutputT> builder() {
        return new Builder();
    }

    public DefaultProcessorTaskController(int parallelism, Duration heartbeatInterval, Queue<InputT> queue, Topic<OutputT> topic) {
        super(parallelism, heartbeatInterval, queue, topic);
    }

    public static class Builder<InputT, OutputT>
    implements TaskController.ProcessorTaskControllerBuilder<InputT, OutputT> {
        private int desiredConcurrency = 1;
        private Duration heartbeatInterval = Duration.ofSeconds(60L);

        public Builder<InputT, OutputT> setDesiredConcurrency(int parallelism) {
            if (parallelism < 1) {
                throw new IllegalArgumentException("desiredConcurrency must be at least 1");
            }
            this.desiredConcurrency = parallelism;
            return this;
        }

        public Builder<InputT, OutputT> setHeartbeatInterval(Duration heartbeatInterval) {
            if (heartbeatInterval == null) {
                throw new NullPointerException();
            }
            if (!heartbeatInterval.isPositive()) {
                throw new IllegalArgumentException("heartbeatInterval must be positive");
            }
            this.heartbeatInterval = heartbeatInterval;
            return this;
        }

        @Override
        public TaskController build(Queue<InputT> queue, Topic<OutputT> topic) {
            return new DefaultTaskController<InputT, OutputT>(this.desiredConcurrency, this.heartbeatInterval, queue, topic);
        }
    }
}

